/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg;

import java.io.Serializable;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.tree.TreeNode;
import org.encog.ml.tree.basic.BasicTreeNode;

public class ProgramNode
extends BasicTreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ProgramExtensionTemplate template;
    private final EncogProgram owner;
    private final ExpressionValue[] data;

    public ProgramNode(EncogProgram theOwner, ProgramExtensionTemplate theTemplate, ProgramNode[] theArgs) {
        this.owner = theOwner;
        this.data = new ExpressionValue[theTemplate.getDataSize()];
        this.template = theTemplate;
        this.addChildNodes(theArgs);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = new ExpressionValue(0L);
            ++i;
        }
    }

    public boolean allConstChildren() {
        boolean result = true;
        for (TreeNode tn : this.getChildNodes()) {
            ProgramNode node = (ProgramNode)tn;
            if (!node.isVariable()) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean allConstDescendants() {
        if (this.isVariable()) {
            return false;
        }
        if (this.isLeaf()) {
            return true;
        }
        for (TreeNode tn : this.getChildNodes()) {
            ProgramNode childNode = (ProgramNode)tn;
            if (childNode.allConstDescendants()) continue;
            return false;
        }
        return true;
    }

    public ExpressionValue evaluate() {
        return this.template.evaluate(this);
    }

    public ProgramNode getChildNode(int index) {
        return (ProgramNode)this.getChildNodes().get(index);
    }

    public ExpressionValue[] getData() {
        return this.data;
    }

    public String getName() {
        return this.template.getName();
    }

    public EncogProgram getOwner() {
        return this.owner;
    }

    public ProgramExtensionTemplate getTemplate() {
        return this.template;
    }

    public boolean isVariable() {
        return this.template.isVariable();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ProgramNode: name=");
        result.append(this.template.getName());
        result.append(", childCount=");
        result.append(this.getChildNodes().size());
        result.append(", childNodes=");
        for (TreeNode tn : this.getChildNodes()) {
            ProgramNode node = (ProgramNode)tn;
            result.append(" ");
            result.append(node.getTemplate().getName());
        }
        result.append("]");
        return result.toString();
    }
}

