/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.distributions;

import java.util.Arrays;
import java.util.Random;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.mathutil.matrices.decomposition.CholeskyDecomposition;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.hmm.distributions.StateDistribution;
import org.encog.util.EngineArray;

public class ContinousDistribution
implements StateDistribution {
    private static final long serialVersionUID = 1L;
    private final int dimension;
    private final double[] mean;
    private final Matrix covariance;
    private Matrix covarianceL = null;
    private Matrix covarianceInv = null;
    private double covarianceDet;
    private static final Random randomGenerator = new Random();
    private CholeskyDecomposition cd;

    public ContinousDistribution(double[] mean, double[][] covariance) {
        this.dimension = covariance.length;
        this.mean = EngineArray.arrayCopy(mean);
        this.covariance = new Matrix(covariance);
        this.update(covariance);
    }

    public ContinousDistribution(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException();
        }
        this.dimension = dimension;
        this.mean = new double[dimension];
        this.covariance = new Matrix(dimension, dimension);
    }

    @Override
    public ContinousDistribution clone() {
        try {
            return (ContinousDistribution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void fit(MLDataSet co) {
        double[] weights = new double[co.size()];
        Arrays.fill(weights, 1.0 / (double)co.size());
        this.fit(co, weights);
    }

    @Override
    public void fit(MLDataSet co, double[] weights) {
        int i;
        if (co.size() < 1 || co.size() != weights.length) {
            throw new IllegalArgumentException();
        }
        double[] mean = new double[this.dimension];
        int r = 0;
        while (r < this.dimension) {
            i = 0;
            for (MLDataPair o : co) {
                int n = r;
                mean[n] = mean[n] + o.getInput().getData(r) * weights[i++];
            }
            ++r;
        }
        double[][] covariance = new double[this.dimension][this.dimension];
        i = 0;
        for (MLDataPair o : co) {
            double[] obs = o.getInput().getData();
            double[] omm = new double[obs.length];
            int j = 0;
            while (j < obs.length) {
                omm[j] = obs[j] - mean[j];
                ++j;
            }
            int r2 = 0;
            while (r2 < this.dimension) {
                int c = 0;
                while (c < this.dimension) {
                    double[] dArray = covariance[r2];
                    int n = c;
                    dArray[n] = dArray[n] + omm[r2] * omm[c] * weights[i];
                    ++c;
                }
                ++r2;
            }
            ++i;
        }
        this.update(covariance);
    }

    @Override
    public MLDataPair generate() {
        double[] d = new double[this.dimension];
        int i = 0;
        while (i < this.dimension) {
            d[i] = randomGenerator.nextGaussian();
            ++i;
        }
        double[] d2 = MatrixMath.multiply(this.covarianceL, d);
        return new BasicMLDataPair(new BasicMLData(EngineArray.add(d2, this.mean)));
    }

    @Override
    public double probability(MLDataPair o) {
        double[] v = o.getInputArray();
        Matrix vmm = Matrix.createColumnMatrix(EngineArray.subtract(v, this.mean));
        Matrix t = MatrixMath.multiply(this.covarianceInv, vmm);
        double expArg = MatrixMath.multiply(MatrixMath.transpose(vmm), t).get(0, 0) * -0.5;
        return Math.exp(expArg) / (Math.pow(Math.PI * 2, (double)this.dimension / 2.0) * Math.pow(this.covarianceDet, 0.5));
    }

    public void update(double[][] covariance) {
        this.cd = new CholeskyDecomposition(new Matrix(covariance));
        this.covarianceL = this.cd.getL();
        this.covarianceInv = this.cd.inverseCholesky();
        this.covarianceDet = this.cd.getDeterminant();
    }

    public double[] getMean() {
        return this.mean;
    }

    public Matrix getCovariance() {
        return this.covariance;
    }
}

