/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import java.util.Iterator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.HiddenMarkovModel;

public class ViterbiCalculator {
    private final double[][] delta;
    private final int[][] psy;
    private final int[] stateSequence;
    private double lnProbability;

    public ViterbiCalculator(MLDataSet oseq, HiddenMarkovModel hmm) {
        if (oseq.size() < 1) {
            throw new IllegalArgumentException("Must not have empty sequence");
        }
        this.delta = new double[oseq.size()][hmm.getStateCount()];
        this.psy = new int[oseq.size()][hmm.getStateCount()];
        this.stateSequence = new int[oseq.size()];
        int i = 0;
        while (i < hmm.getStateCount()) {
            this.delta[0][i] = -Math.log(hmm.getPi(i)) - Math.log(hmm.getStateDistribution(i).probability(oseq.get(0)));
            this.psy[0][i] = 0;
            ++i;
        }
        Iterator oseqIterator = oseq.iterator();
        if (oseqIterator.hasNext()) {
            oseqIterator.next();
        }
        int t = 1;
        while (oseqIterator.hasNext()) {
            MLDataPair observation = (MLDataPair)oseqIterator.next();
            int i2 = 0;
            while (i2 < hmm.getStateCount()) {
                this.computeStep(hmm, observation, t, i2);
                ++i2;
            }
            ++t;
        }
        this.lnProbability = Double.MAX_VALUE;
        int i3 = 0;
        while (i3 < hmm.getStateCount()) {
            double thisProbability = this.delta[oseq.size() - 1][i3];
            if (this.lnProbability > thisProbability) {
                this.lnProbability = thisProbability;
                this.stateSequence[oseq.size() - 1] = i3;
            }
            ++i3;
        }
        this.lnProbability = -this.lnProbability;
        int t2 = oseq.size() - 2;
        while (t2 >= 0) {
            this.stateSequence[t2] = this.psy[t2 + 1][this.stateSequence[t2 + 1]];
            --t2;
        }
    }

    private void computeStep(HiddenMarkovModel hmm, MLDataPair o, int t, int j) {
        double minDelta = Double.MAX_VALUE;
        int min_psy = 0;
        int i = 0;
        while (i < hmm.getStateCount()) {
            double thisDelta = this.delta[t - 1][i] - Math.log(hmm.getTransitionProbability(i, j));
            if (minDelta > thisDelta) {
                minDelta = thisDelta;
                min_psy = i;
            }
            ++i;
        }
        this.delta[t][j] = minDelta - Math.log(hmm.getStateDistribution(j).probability(o));
        this.psy[t][j] = min_psy;
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    public int[] stateSequence() {
        return (int[])this.stateSequence.clone();
    }
}

