/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.HiddenMarkovModel;
import org.encog.ml.hmm.alog.ForwardBackwardCalculator;

public class ForwardBackwardScaledCalculator
extends ForwardBackwardCalculator {
    private final double[] ctFactors;
    private double lnProbability;

    public ForwardBackwardScaledCalculator(MLDataSet oseq, HiddenMarkovModel hmm) {
        this(oseq, hmm, EnumSet.of(ForwardBackwardCalculator.Computation.ALPHA));
    }

    public ForwardBackwardScaledCalculator(MLDataSet oseq, HiddenMarkovModel hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        if (oseq.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.ctFactors = new double[oseq.size()];
        Arrays.fill(this.ctFactors, 0.0);
        this.computeAlpha(hmm, oseq);
        if (flags.contains((Object)ForwardBackwardCalculator.Computation.BETA)) {
            this.computeBeta(hmm, oseq);
        }
        this.computeProbability(oseq, hmm, flags);
    }

    @Override
    protected void computeAlpha(HiddenMarkovModel hmm, MLDataSet oseq) {
        this.alpha = new double[oseq.size()][hmm.getStateCount()];
        int i = 0;
        while (i < hmm.getStateCount()) {
            this.computeAlphaInit(hmm, oseq.get(0), i);
            ++i;
        }
        this.scale(this.ctFactors, this.alpha, 0);
        Iterator seqIterator = oseq.iterator();
        if (seqIterator.hasNext()) {
            seqIterator.next();
        }
        int t = 1;
        while (t < oseq.size()) {
            MLDataPair observation = (MLDataPair)seqIterator.next();
            int i2 = 0;
            while (i2 < hmm.getStateCount()) {
                this.computeAlphaStep(hmm, observation, t, i2);
                ++i2;
            }
            this.scale(this.ctFactors, this.alpha, t);
            ++t;
        }
    }

    @Override
    protected void computeBeta(HiddenMarkovModel hmm, MLDataSet oseq) {
        this.beta = new double[oseq.size()][hmm.getStateCount()];
        int i = 0;
        while (i < hmm.getStateCount()) {
            this.beta[oseq.size() - 1][i] = 1.0 / this.ctFactors[oseq.size() - 1];
            ++i;
        }
        int t = oseq.size() - 2;
        while (t >= 0) {
            int i2 = 0;
            while (i2 < hmm.getStateCount()) {
                this.computeBetaStep(hmm, oseq.get(t + 1), t, i2);
                double[] dArray = this.beta[t];
                int n = i2++;
                dArray[n] = dArray[n] / this.ctFactors[t];
            }
            --t;
        }
    }

    private void computeProbability(MLDataSet oseq, HiddenMarkovModel hmm, EnumSet<ForwardBackwardCalculator.Computation> flags) {
        this.lnProbability = 0.0;
        int t = 0;
        while (t < oseq.size()) {
            this.lnProbability += Math.log(this.ctFactors[t]);
            ++t;
        }
        this.probability = Math.exp(this.lnProbability);
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    private void scale(double[] ctFactors, double[][] array, int t) {
        double[] table = array[t];
        double sum = 0.0;
        double[] dArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            double element = dArray[n2];
            sum += element;
            ++n2;
        }
        ctFactors[t] = sum;
        int i = 0;
        while (i < table.length) {
            int n3 = i++;
            table[n3] = table[n3] / sum;
        }
    }
}

