/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.ea.score.parallel;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.ml.CalculateScore;
import org.encog.ml.ea.codec.GeneticCODEC;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.score.AdjustScore;
import org.encog.ml.ea.score.parallel.ParallelScoreTask;
import org.encog.ml.ea.species.Species;
import org.encog.ml.genetic.GeneticError;
import org.encog.util.concurrency.MultiThreadable;

public class ParallelScore
implements MultiThreadable {
    private final Population population;
    private final GeneticCODEC codec;
    private final CalculateScore scoreFunction;
    private final List<AdjustScore> adjusters;
    private int threads;
    private int actualThreads;
    private Exception reportedError;

    public ParallelScore(Population thePopulation, GeneticCODEC theCODEC, List<AdjustScore> theAdjusters, CalculateScore theScoreFunction, int theThreadCount) {
        this.codec = theCODEC;
        this.population = thePopulation;
        this.scoreFunction = theScoreFunction;
        this.adjusters = theAdjusters;
        this.actualThreads = 0;
    }

    public Population getPopulation() {
        return this.population;
    }

    public CalculateScore getScoreFunction() {
        return this.scoreFunction;
    }

    public GeneticCODEC getCodec() {
        return this.codec;
    }

    public void process() {
        this.actualThreads = this.scoreFunction.requireSingleThreaded() ? 1 : (this.threads == 0 ? Runtime.getRuntime().availableProcessors() : this.threads);
        ExecutorService taskExecutor = null;
        taskExecutor = this.threads == 1 ? Executors.newSingleThreadScheduledExecutor() : Executors.newFixedThreadPool(this.actualThreads);
        for (Species species : this.population.getSpecies()) {
            for (Genome genome : species.getMembers()) {
                taskExecutor.execute(new ParallelScoreTask(genome, this));
            }
        }
        taskExecutor.shutdown();
        try {
            taskExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new GeneticError(e);
        }
        if (this.reportedError != null) {
            throw new GeneticError(this.reportedError);
        }
    }

    public List<AdjustScore> getAdjusters() {
        return this.adjusters;
    }

    @Override
    public int getThreadCount() {
        return this.threads;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.threads = numThreads;
    }

    public void reportError(Exception ex) {
        this.reportedError = ex;
    }
}

