/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile.division;

import java.util.List;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.ml.data.versatile.MatrixMLDataSet;
import org.encog.ml.data.versatile.VersatileMLDataSet;
import org.encog.ml.data.versatile.division.DataDivision;

public class PerformDataDivision {
    private final boolean shuffle;
    private final GenerateRandom rnd;

    public PerformDataDivision(boolean theShuffle, GenerateRandom theRandom) {
        this.shuffle = theShuffle;
        this.rnd = theRandom;
    }

    public void perform(List<DataDivision> dataDivisionList, VersatileMLDataSet dataset, int inputCount, int idealCount) {
        this.generateCounts(dataDivisionList, dataset.getData().length);
        this.generateMasks(dataDivisionList);
        if (this.shuffle) {
            this.performShuffle(dataDivisionList, dataset.getData().length);
        }
        this.createDividedDatasets(dataDivisionList, dataset, inputCount, idealCount);
    }

    private void createDividedDatasets(List<DataDivision> dataDivisionList, VersatileMLDataSet parentDataset, int inputCount, int idealCount) {
        for (DataDivision division : dataDivisionList) {
            MatrixMLDataSet dataset = new MatrixMLDataSet(parentDataset.getData(), inputCount, idealCount, division.getMask());
            dataset.setLagWindowSize(parentDataset.getLagWindowSize());
            dataset.setLeadWindowSize(parentDataset.getLeadWindowSize());
            division.setDataset(dataset);
        }
    }

    private void performShuffle(List<DataDivision> dataDivisionList, int totalCount) {
        int i = totalCount - 1;
        while (i > 0) {
            int n = this.rnd.nextInt(i + 1);
            this.virtualSwap(dataDivisionList, i, n);
            --i;
        }
    }

    private void virtualSwap(List<DataDivision> dataDivisionList, int a, int b) {
        DataDivision divA = null;
        DataDivision divB = null;
        int offsetA = 0;
        int offsetB = 0;
        int baseIndex = 0;
        for (DataDivision division : dataDivisionList) {
            if (divA == null && a < (baseIndex += division.getCount())) {
                divA = division;
                offsetA = a - (baseIndex - division.getCount());
            }
            if (divB != null || b >= baseIndex) continue;
            divB = division;
            offsetB = b - (baseIndex - division.getCount());
        }
        int temp = divA.getMask()[offsetA];
        divA.getMask()[offsetA] = divB.getMask()[offsetB];
        divB.getMask()[offsetB] = temp;
    }

    private void generateMasks(List<DataDivision> dataDivisionList) {
        int idx = 0;
        for (DataDivision division : dataDivisionList) {
            division.allocateMask(division.getCount());
            int i = 0;
            while (i < division.getCount()) {
                division.getMask()[i] = idx++;
                ++i;
            }
        }
    }

    private void generateCounts(List<DataDivision> dataDivisionList, int totalCount) {
        int countSofar = 0;
        for (DataDivision division : dataDivisionList) {
            int count = (int)(division.getPercent() * (double)totalCount);
            division.setCount(count);
            countSofar += count;
        }
        int remaining = totalCount - countSofar;
        while (remaining-- > 0) {
            int idx = this.rnd.nextInt(dataDivisionList.size());
            DataDivision div = dataDivisionList.get(idx);
            div.setCount(div.getCount() + 1);
        }
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public GenerateRandom getRandom() {
        return this.rnd;
    }
}

