/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.kmeans.Centroid;

public class BasicMLDataCentroid
implements Centroid<MLData>,
Cloneable {
    private BasicMLData value;
    private int size;

    public BasicMLDataCentroid(MLData o) {
        this.value = (BasicMLData)o.clone();
        this.size = 1;
    }

    @Override
    public void add(MLData d) {
        double[] a = d.getData();
        int i = 0;
        while (i < this.value.size()) {
            this.value.setData(i, (this.value.getData(i) * (double)this.size + a[i]) / (double)(this.size + 1));
            ++i;
        }
        ++this.size;
    }

    @Override
    public void remove(MLData d) {
        double[] a = d.getData();
        int i = 0;
        while (i < this.value.size()) {
            this.value.setData(i, (this.value.getData(i) * (double)this.size - a[i]) / (double)(this.size - 1));
            ++i;
        }
        --this.size;
    }

    @Override
    public double distance(MLData d) {
        MLData diff = this.value.minus(d);
        double sum = 0.0;
        int i = 0;
        while (i < diff.size()) {
            sum += diff.getData(i) * diff.getData(i);
            ++i;
        }
        return Math.sqrt(sum);
    }
}

