/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.parse;

import java.util.ArrayList;
import java.util.List;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.parse.ParsedEvent;

public class ParsedProbability {
    private final List<ParsedEvent> baseEvents = new ArrayList<ParsedEvent>();
    private final List<ParsedEvent> givenEvents = new ArrayList<ParsedEvent>();

    public void addGivenEvent(ParsedEvent event) {
        this.givenEvents.add(event);
    }

    public void addBaseEvent(ParsedEvent event) {
        this.baseEvents.add(event);
    }

    public int[] getArgs(BayesianNetwork network) {
        int[] result = new int[this.givenEvents.size()];
        int i = 0;
        while (i < this.givenEvents.size()) {
            ParsedEvent givenEvent = this.givenEvents.get(i);
            BayesianEvent actualEvent = network.getEvent(givenEvent.getLabel());
            result[i] = givenEvent.resolveValue(actualEvent);
            ++i;
        }
        return result;
    }

    public ParsedEvent getChildEvent() {
        if (this.baseEvents.size() > 1) {
            throw new BayesianError("Only one base event may be used to define a probability, i.e. P(a), not P(a,b).");
        }
        if (this.baseEvents.size() == 0) {
            throw new BayesianError("At least one event must be provided, i.e. P() or P(|a,b,c) is not allowed.");
        }
        return this.baseEvents.get(0);
    }

    public void defineTruthTable(BayesianNetwork network, double result) {
        ParsedEvent childParsed = this.getChildEvent();
        BayesianEvent childEvent = network.requireEvent(childParsed.getLabel());
        int[] args = this.getArgs(network);
        childEvent.getTable().addLine(result, childParsed.resolveValue(childEvent), args);
    }

    public List<ParsedEvent> getBaseEvents() {
        return this.baseEvents;
    }

    public List<ParsedEvent> getGivenEvents() {
        return this.givenEvents;
    }

    public void defineRelationships(BayesianNetwork network) {
        ParsedEvent childParsed = this.getChildEvent();
        BayesianEvent childEvent = network.requireEvent(childParsed.getLabel());
        for (ParsedEvent event : this.givenEvents) {
            BayesianEvent parentEvent = network.requireEvent(event.getLabel());
            network.createDependency(parentEvent, childEvent);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[ParsedProbability:baseEvents=");
        result.append(this.baseEvents.toString());
        result.append(",givenEvents=");
        result.append(this.givenEvents.toString());
        result.append("]");
        return result.toString();
    }
}

