/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.parse;

import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.ml.bayesian.parse.ParsedChoice;
import org.encog.ml.bayesian.parse.ParsedEvent;
import org.encog.ml.bayesian.parse.ParsedProbability;
import org.encog.util.SimpleParser;
import org.encog.util.csv.CSVFormat;

public class ParseProbability {
    private final BayesianNetwork network;

    public ParseProbability(BayesianNetwork theNetwork) {
        this.network = theNetwork;
    }

    private void addEvents(SimpleParser parser, List<ParsedEvent> results, String delim) {
        boolean done = false;
        StringBuilder l = new StringBuilder();
        while (!done && !parser.eol()) {
            char ch = parser.peek();
            if (delim.indexOf(ch) != -1) {
                ParsedEvent parsedEvent;
                String l2;
                if (ch == ')' || ch == '|') {
                    done = true;
                }
                if (l.length() > 0 && l.charAt(0) == '+') {
                    l2 = l.toString().substring(1);
                    parsedEvent = new ParsedEvent(l2.trim());
                    parsedEvent.setValue("0");
                } else if (l.length() > 0 && l.charAt(0) == '-') {
                    l2 = l.toString().substring(1);
                    parsedEvent = new ParsedEvent(l2.trim());
                    parsedEvent.setValue("1");
                } else {
                    l2 = l.toString();
                    parsedEvent = new ParsedEvent(l2.trim());
                }
                if (ch == '[') {
                    parser.advance();
                    int index = 0;
                    while (ch != ']' && !parser.eol()) {
                        String labelName = parser.readToChars(":,]");
                        if (parser.peek() == ':') {
                            parser.advance();
                            parser.eatWhiteSpace();
                            double min = Double.parseDouble(parser.readToWhiteSpace());
                            parser.eatWhiteSpace();
                            if (!parser.lookAhead("to", true)) {
                                throw new BayesianError("Expected \"to\" in probability choice range.");
                            }
                            parser.advance(2);
                            double max = CSVFormat.EG_FORMAT.parse(parser.readToChars(",]"));
                            parsedEvent.getList().add(new ParsedChoice(labelName, min, max));
                        } else {
                            parsedEvent.getList().add(new ParsedChoice(labelName, index++));
                        }
                        parser.eatWhiteSpace();
                        ch = parser.peek();
                        if (ch != ',') continue;
                        parser.advance();
                    }
                }
                if (parser.peek() == '=') {
                    parser.readChar();
                    String value = parser.readToChars(delim);
                    parsedEvent.setValue(value);
                }
                if (ch == ',') {
                    parser.advance();
                }
                if (ch == ']') {
                    parser.advance();
                }
                if (parsedEvent.getLabel().length() > 0) {
                    results.add(parsedEvent);
                }
                l.setLength(0);
                continue;
            }
            parser.advance();
            l.append(ch);
        }
    }

    public ParsedProbability parse(String line) {
        ParsedProbability result = new ParsedProbability();
        SimpleParser parser = new SimpleParser(line);
        parser.eatWhiteSpace();
        if (!parser.lookAhead("P(", true)) {
            throw new EncogError("Bayes table lines must start with P(");
        }
        parser.advance(2);
        this.addEvents(parser, result.getBaseEvents(), "|,)=[]");
        if (parser.peek() == '|') {
            parser.advance();
            this.addEvents(parser, result.getGivenEvents(), ",)=[]");
        }
        if (parser.peek() != ')') {
            throw new BayesianError("Probability not properly terminated.");
        }
        return result;
    }

    public static List<ParsedProbability> parseProbabilityList(BayesianNetwork network, String line) {
        ArrayList<ParsedProbability> result = new ArrayList<ParsedProbability>();
        StringBuilder prob = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == ')') {
                prob.append(ch);
                ParseProbability parse = new ParseProbability(network);
                ParsedProbability parsedProbability = parse.parse(prob.toString());
                result.add(parsedProbability);
                prob.setLength(0);
            } else {
                prob.append(ch);
            }
            ++i;
        }
        return result;
    }
}

