/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.rbf;

import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.util.EngineArray;
import org.encog.util.Format;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public abstract class BasicRBF
implements RadialBasisFunction {
    private static final long serialVersionUID = 1L;
    private double[] center;
    private double peak;
    private double width;

    @Override
    public final double getCenter(int dimension) {
        return this.center[dimension];
    }

    @Override
    public final double[] getCenters() {
        return this.center;
    }

    @Override
    public final int getDimensions() {
        return this.center.length;
    }

    @Override
    public final double getPeak() {
        return this.peak;
    }

    @Override
    public final double getWidth() {
        return this.width;
    }

    @Override
    public final void setCenters(double[] centers) {
        this.center = EngineArray.arrayCopy(centers);
    }

    @Override
    public final void setPeak(double thePeak) {
        this.peak = thePeak;
    }

    @Override
    public final void setWidth(double theWidth) {
        this.width = theWidth;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(":width=");
        result.append(Format.formatDouble(this.getWidth(), 10));
        result.append(",peak=");
        result.append(Format.formatDouble(this.getPeak(), 10));
        result.append(",center=");
        StringBuilder list = new StringBuilder();
        NumberList.toList(CSVFormat.EG_FORMAT, list, this.getCenters());
        result.append((CharSequence)list);
        result.append("]");
        return result.toString();
    }
}

