/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.EncogError;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;

public class FanInRandomizer
extends BasicRandomizer {
    static final String ERROR = "To use FanInRandomizer you must present a Matrix or 2D array type value.";
    private static final double DEFAULT_BOUNDARY = 2.4;
    private final double lowerBound;
    private final double upperBound;
    private final boolean sqrt;

    public FanInRandomizer() {
        this(-2.4, 2.4, false);
    }

    public FanInRandomizer(double boundary, boolean sqrt) {
        this(-boundary, boundary, sqrt);
    }

    public FanInRandomizer(double aLowerBound, double anUpperBound, boolean sqrt) {
        this.lowerBound = aLowerBound;
        this.upperBound = anUpperBound;
        this.sqrt = sqrt;
    }

    private double calculateValue(int rows) {
        double rowValue = this.sqrt ? Math.sqrt(rows) : (double)rows;
        return this.lowerBound / rowValue + this.nextDouble() * ((this.upperBound - this.lowerBound) / rowValue);
    }

    private void causeError() {
        throw new EncogError(ERROR);
    }

    @Override
    public double randomize(double d) {
        this.causeError();
        return 0.0;
    }

    @Override
    public void randomize(double[] d) {
        int i = 0;
        while (i < d.length) {
            d[i] = this.calculateValue(1);
            ++i;
        }
    }

    @Override
    public void randomize(double[][] d) {
        int row = 0;
        while (row < d.length) {
            int col = 0;
            while (col < d[0].length) {
                d[row][col] = this.calculateValue(d.length);
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void randomize(Matrix m) {
        int row = 0;
        while (row < m.getRows()) {
            int col = 0;
            while (col < m.getCols()) {
                m.set(row, col, this.calculateValue(m.getRows()));
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void randomize(BasicNetwork network, int fromLayer) {
        int fromCount = network.getLayerTotalNeuronCount(fromLayer);
        int toCount = network.getLayerNeuronCount(fromLayer + 1);
        int fromNeuron = 0;
        while (fromNeuron < fromCount) {
            int toNeuron = 0;
            while (toNeuron < toCount) {
                double v = network.getWeight(fromLayer, fromNeuron, toNeuron);
                v = this.calculateValue(toCount);
                network.setWeight(fromLayer, fromNeuron, toNeuron, v);
                ++toNeuron;
            }
            ++fromNeuron;
        }
    }
}

