/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices.decomposition;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;

public class LUDecomposition {
    private double[][] LU;
    private int m;
    private int n;
    private int pivsign;
    private int[] piv;

    public LUDecomposition(Matrix A) {
        this.LU = A.getArrayCopy();
        this.m = A.getRows();
        this.n = A.getCols();
        this.piv = new int[this.m];
        int i = 0;
        while (i < this.m) {
            this.piv[i] = i;
            ++i;
        }
        this.pivsign = 1;
        double[] LUcolj = new double[this.m];
        int j = 0;
        while (j < this.n) {
            int i2 = 0;
            while (i2 < this.m) {
                LUcolj[i2] = this.LU[i2][j];
                ++i2;
            }
            i2 = 0;
            while (i2 < this.m) {
                double[] LUrowi = this.LU[i2];
                int kmax = Math.min(i2, j);
                double s = 0.0;
                int k = 0;
                while (k < kmax) {
                    s += LUrowi[k] * LUcolj[k];
                    ++k;
                }
                int n = i2++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            int i3 = j + 1;
            while (i3 < this.m) {
                if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                    p = i3;
                }
                ++i3;
            }
            if (p != j) {
                int k = 0;
                while (k < this.n) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                    ++k;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j < this.m & this.LU[j][j] != 0.0) {
                i3 = j + 1;
                while (i3 < this.m) {
                    double[] dArray = this.LU[i3];
                    int n = j;
                    dArray[n] = dArray[n] / this.LU[j][j];
                    ++i3;
                }
            }
            ++j;
        }
    }

    public boolean isNonsingular() {
        int j = 0;
        while (j < this.n) {
            if (this.LU[j][j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public Matrix getL() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] L = X.getData();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                L[i][j] = i > j ? this.LU[i][j] : (i == j ? 1.0 : 0.0);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix getU() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] U = X.getData();
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                U[i][j] = i <= j ? this.LU[i][j] : 0.0;
                ++j;
            }
            ++i;
        }
        return X;
    }

    public int[] getPivot() {
        int[] p = new int[this.m];
        int i = 0;
        while (i < this.m) {
            p[i] = this.piv[i];
            ++i;
        }
        return p;
    }

    public double[] getDoublePivot() {
        double[] vals = new double[this.m];
        int i = 0;
        while (i < this.m) {
            vals[i] = this.piv[i];
            ++i;
        }
        return vals;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        double d = this.pivsign;
        int j = 0;
        while (j < this.n) {
            d *= this.LU[j][j];
            ++j;
        }
        return d;
    }

    public Matrix solve(Matrix B) {
        int j;
        int i;
        if (B.getRows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new RuntimeException("Matrix is singular.");
        }
        int nx = B.getCols();
        Matrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
        double[][] X = Xmat.getData();
        int k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < nx) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / this.LU[k][k];
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return Xmat;
    }

    public double[] Solve(double[] value) {
        int j;
        if (value == null) {
            throw new MatrixError("value");
        }
        if (value.length != this.LU.length) {
            throw new MatrixError("Invalid matrix dimensions.");
        }
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int count = value.length;
        double[] b = new double[count];
        int i = 0;
        while (i < b.length) {
            b[i] = value[this.piv[i]];
            ++i;
        }
        int rows = this.LU[0].length;
        int columns = this.LU[0].length;
        double[][] lu = this.LU;
        double[] X = new double[count];
        int i2 = 0;
        while (i2 < rows) {
            X[i2] = b[i2];
            j = 0;
            while (j < i2) {
                int n = i2;
                X[n] = X[n] - lu[i2][j] * X[j];
                ++j;
            }
            ++i2;
        }
        i2 = rows - 1;
        while (i2 >= 0) {
            j = columns - 1;
            while (j > i2) {
                int n = i2;
                X[n] = X[n] - lu[i2][j] * X[j];
                --j;
            }
            int n = i2;
            X[n] = X[n] / lu[i2][i2];
            --i2;
        }
        return X;
    }

    public double[][] inverse() {
        int j;
        int i;
        if (!this.isNonsingular()) {
            throw new MatrixError("Matrix is singular");
        }
        int rows = this.LU.length;
        int columns = this.LU[0].length;
        int count = rows;
        double[][] lu = this.LU;
        double[][] X = new double[rows][columns];
        int i2 = 0;
        while (i2 < rows) {
            int k = this.piv[i2];
            X[i2][k] = 1.0;
            ++i2;
        }
        int k = 0;
        while (k < columns) {
            i = k + 1;
            while (i < columns) {
                j = 0;
                while (j < count) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * lu[i][k];
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = columns - 1;
        while (k >= 0) {
            int j2 = 0;
            while (j2 < count) {
                double[] dArray = X[k];
                int n = j2++;
                dArray[n] = dArray[n] / lu[k][k];
            }
            i = 0;
            while (i < k) {
                j = 0;
                while (j < count) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] - X[k][j] * lu[i][k];
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return X;
    }
}

