/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.dimension;

import java.util.Arrays;
import org.encog.mathutil.dimension.DimensionConstraint;

public class MultiDimension {
    private final int[] dimensions;

    public MultiDimension(int n) {
        this.dimensions = new int[n];
    }

    public MultiDimension(MultiDimension lower) {
        this.dimensions = (int[])lower.getDimensions().clone();
    }

    public int getDimension(int d) {
        return this.dimensions[d];
    }

    public int size() {
        return this.dimensions.length;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public boolean forward(DimensionConstraint constraint) {
        int i = 0;
        do {
            int n = i;
            this.dimensions[n] = this.dimensions[n] + 1;
            if (this.dimensions[i] <= constraint.getUpper(i)) {
                return true;
            }
            this.dimensions[i] = constraint.getLower(i);
        } while (++i < this.size());
        return false;
    }

    public int flatten(DimensionConstraint constraint) {
        int result = 0;
        int mult = 1;
        int i = 0;
        while (i < this.size()) {
            result += mult * this.dimensions[i];
            mult *= constraint.getRange(i);
            ++i;
        }
        return result;
    }

    public void setDimension(int d, int value) {
        this.dimensions[d] = value;
    }

    public String toString() {
        return Arrays.toString(this.dimensions);
    }

    public double calculateLowerStep(DimensionConstraint constraint, int d) {
        if (this.dimensions[d] <= constraint.getLower(d)) {
            return 0.0;
        }
        return -1.0;
    }

    public double calculateUpperStep(DimensionConstraint constraint, int d) {
        if (this.dimensions[d] <= constraint.getLower(d)) {
            return 0.0;
        }
        return 1.0;
    }
}

