/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.bagging;

import java.util.ArrayList;
import org.encog.ensemble.Ensemble;
import org.encog.ensemble.EnsembleAggregator;
import org.encog.ensemble.EnsembleML;
import org.encog.ensemble.EnsembleMLMethodFactory;
import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ensemble.EnsembleTypes;
import org.encog.ensemble.data.factories.EnsembleDataSetFactory;
import org.encog.ensemble.data.factories.ResamplingDataSetFactory;

public class Bagging
extends Ensemble {
    private int splits;

    public Bagging(int splits, int dataSetSize, EnsembleMLMethodFactory mlFactory, EnsembleTrainFactory trainFactory, EnsembleAggregator aggregator) {
        this(splits, dataSetSize, mlFactory, trainFactory, aggregator, new ResamplingDataSetFactory(dataSetSize));
    }

    public Bagging(int splits, int dataSetSize, EnsembleMLMethodFactory mlFactory, EnsembleTrainFactory trainFactory, EnsembleAggregator aggregator, EnsembleDataSetFactory edf) {
        this.dataSetFactory = edf;
        this.splits = splits;
        this.mlFactory = mlFactory;
        this.trainFactory = trainFactory;
        this.members = new ArrayList();
        this.aggregator = aggregator;
        this.initMembers();
    }

    @Override
    public void initMembers() {
        this.initMembersBySplits(this.splits);
    }

    @Override
    public EnsembleTypes.ProblemType getProblemType() {
        return EnsembleTypes.ProblemType.CLASSIFICATION;
    }

    @Override
    public EnsembleML getMember(int memberNumber) {
        return (EnsembleML)this.members.get(memberNumber);
    }

    public void trainStep() {
        for (EnsembleML current : this.members) {
            current.trainStep();
        }
    }
}

