/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.aggregator;

import java.util.ArrayList;
import org.encog.ensemble.EnsembleAggregator;
import org.encog.ensemble.EnsembleML;
import org.encog.ensemble.EnsembleMLMethodFactory;
import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ensemble.GenericEnsembleML;
import org.encog.ensemble.data.EnsembleDataSet;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;

public class MetaClassifier
implements EnsembleAggregator {
    EnsembleML classifier;
    EnsembleMLMethodFactory mlFact;
    EnsembleTrainFactory etFact;
    double trainError;
    int members;
    boolean adaptiveError = false;

    public MetaClassifier(double trainError, EnsembleMLMethodFactory mlFact, EnsembleTrainFactory etFact, boolean adaptiveError) {
        this.trainError = trainError;
        this.mlFact = mlFact;
        this.etFact = etFact;
        this.adaptiveError = adaptiveError;
        this.members = 1;
    }

    public MetaClassifier(double trainError, EnsembleMLMethodFactory mlFact, EnsembleTrainFactory etFact) {
        this(trainError, mlFact, etFact, false);
    }

    public double getTrainingError() {
        return this.trainError;
    }

    public void setTrainingError(double trainError) {
        this.trainError = trainError;
    }

    @Override
    public void setNumberOfMembers(int members) {
        this.members = members;
    }

    @Override
    public MLData evaluate(ArrayList<MLData> outputs) {
        BasicMLData merged_outputs = new BasicMLData(this.classifier.getInputCount());
        for (MLData output : outputs) {
            int index = 0;
            double[] dArray = output.getData();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double val = dArray[n2];
                merged_outputs.add(index++, val);
                ++n2;
            }
        }
        return this.classifier.compute(merged_outputs);
    }

    @Override
    public String getLabel() {
        String ret = "metaclassifier-" + this.mlFact.getLabel() + "-" + this.trainError + "-" + this.etFact.getLabel();
        if (this.adaptiveError) {
            ret = String.valueOf(ret) + "-adaptive";
        }
        return ret;
    }

    @Override
    public void train() {
        if (this.classifier != null) {
            double targetError = this.adaptiveError ? this.trainError / (double)this.members : this.trainError;
            this.classifier.train(targetError);
        } else {
            System.err.println("Trying to train a null classifier in MetaClassifier");
        }
    }

    @Override
    public void setTrainingSet(EnsembleDataSet trainingSet) {
        this.mlFact.setSizeMultiplier(this.members);
        this.classifier = new GenericEnsembleML(this.mlFact.createML(trainingSet.getInputSize(), trainingSet.getIdealSize()), this.mlFact.getLabel());
        this.classifier.setTraining(this.etFact.getTraining(this.classifier.getMl(), trainingSet));
        this.classifier.setTrainingSet(trainingSet);
    }

    @Override
    public boolean needsTraining() {
        return true;
    }
}

