/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.visualize.basic;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.encog.ca.universe.DiscreteCell;
import org.encog.ca.universe.Universe;
import org.encog.ca.universe.UniverseCell;
import org.encog.ca.visualize.CAVisualizer;

public class BasicCAVisualizer
implements CAVisualizer {
    private Universe universe;
    private int currentZoom;
    private int zoom = 1;
    private int width;
    private int height;
    private int[] pixels;
    private BufferedImage currentImage;
    private WritableRaster raster;

    public BasicCAVisualizer(Universe theUniverse) {
        this.universe = theUniverse;
    }

    private void fillCell(int row, int col, UniverseCell cell) {
        int y = 0;
        while (y < this.currentZoom) {
            int idx = (row * this.currentZoom + y) * (this.width * this.currentZoom) * 3 + col * this.currentZoom * 3;
            int x = 0;
            while (x < this.currentZoom) {
                if (cell instanceof DiscreteCell) {
                    if (cell.get(0) > 0.0) {
                        this.pixels[idx++] = 255;
                        this.pixels[idx++] = 255;
                        this.pixels[idx++] = 255;
                    } else {
                        this.pixels[idx++] = 0;
                        this.pixels[idx++] = 0;
                        this.pixels[idx++] = 0;
                    }
                } else {
                    int i = 0;
                    while (i < 3) {
                        double d = (cell.get(i) + 1.0) / 2.0;
                        this.pixels[idx++] = Math.min((int)(d * 255.0), 255);
                        ++i;
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public Image visualize() {
        this.currentZoom = this.zoom;
        this.width = this.universe.getColumns();
        this.height = this.universe.getRows();
        int imageSize = this.width * this.height * this.currentZoom * this.currentZoom * 3;
        if (this.pixels == null || this.pixels.length != imageSize) {
            this.currentImage = new BufferedImage(this.width * this.currentZoom, this.height * this.currentZoom, 1);
            this.raster = this.currentImage.getRaster();
            this.pixels = new int[imageSize];
        }
        int row = 0;
        while (row < this.height) {
            int col = 0;
            while (col < this.width) {
                UniverseCell cell = this.universe.get(row, col);
                this.fillCell(row, col, cell);
                ++col;
            }
            ++row;
        }
        this.raster.setPixels(0, 0, this.width * this.currentZoom, this.height * this.currentZoom, this.pixels);
        return this.currentImage;
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(int z) {
        this.zoom = z;
    }
}

