/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.generate.generators;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.app.generate.AnalystCodeGenerationError;
import org.encog.app.generate.generators.TemplateGenerator;
import org.encog.engine.network.activation.ActivationElliott;
import org.encog.engine.network.activation.ActivationElliottSymmetric;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.neural.flat.FlatNetwork;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;
import org.encog.util.file.ResourceInputStream;
import org.encog.util.logging.EncogLogging;

public abstract class AbstractTemplateGenerator
implements TemplateGenerator {
    private final StringBuilder contents = new StringBuilder();
    private EncogAnalyst analyst;
    private int indentLevel = 0;

    public void addLine(String line) {
        int i = 0;
        while (i < this.indentLevel) {
            this.contents.append("\t");
            ++i;
        }
        this.contents.append(line);
        this.contents.append("\n");
    }

    public void addNameValue(String name, double[] data) {
        StringBuilder value = new StringBuilder();
        if (data == null) {
            value.append(name);
            value.append(" = " + this.getNullArray() + ";");
            this.addLine(value.toString());
        } else {
            this.toBrokenList(value, data);
            this.addNameValue(name, "{" + value.toString() + "}");
        }
    }

    public void addNameValue(String name, int value) {
        this.addNameValue(name, "" + value);
    }

    public void addNameValue(String name, int[] data) {
        StringBuilder value = new StringBuilder();
        if (data == null) {
            value.append(name);
            value.append(" = " + this.getNullArray() + ";");
            this.addLine(value.toString());
        } else {
            this.toBrokenList(value, data);
            this.addNameValue(name, "{" + value.toString() + "}");
        }
    }

    public void addNameValue(String name, String value) {
        StringBuilder line = new StringBuilder();
        line.append(name);
        line.append(" = ");
        if (value == null) {
            line.append(this.getNullArray());
        } else {
            line.append(value);
        }
        line.append(";");
        this.addLine(line.toString());
    }

    public int[] createActivations(FlatNetwork flat) {
        int[] result = new int[flat.getActivationFunctions().length];
        int i = 0;
        while (i < flat.getActivationFunctions().length) {
            ActivationFunction af = flat.getActivationFunctions()[i];
            if (af instanceof ActivationLinear) {
                result[i] = 0;
            } else if (af instanceof ActivationTANH) {
                result[i] = 1;
            }
            if (af instanceof ActivationSigmoid) {
                result[i] = 2;
            }
            if (af instanceof ActivationElliottSymmetric) {
                result[i] = 3;
            }
            if (af instanceof ActivationElliott) {
                result[i] = 4;
            }
            ++i;
        }
        return result;
    }

    public double[] createParams(FlatNetwork flat) {
        double[] result = new double[flat.getActivationFunctions().length];
        EngineArray.fill(result, 1.0);
        return result;
    }

    @Override
    public void generate(EncogAnalyst theAnalyst) {
        InputStream is = null;
        BufferedReader br = null;
        this.analyst = theAnalyst;
        try {
            try {
                String line;
                is = ResourceInputStream.openResourceInputStream(this.getTemplatePath());
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("~~")) {
                        this.processToken(line.substring(2).trim());
                        continue;
                    }
                    this.contents.append(line);
                    this.contents.append("\n");
                }
                br.close();
            }
            catch (IOException ex) {
                throw new AnalystCodeGenerationError(ex);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    EncogLogging.log(2, ex);
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    EncogLogging.log(2, ex);
                }
            }
        }
    }

    public EncogAnalyst getAnalyst() {
        return this.analyst;
    }

    @Override
    public String getContents() {
        return this.contents.toString();
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public abstract String getNullArray();

    public abstract String getTemplatePath();

    public void indentIn() {
        ++this.indentLevel;
    }

    public void indentOut() {
        --this.indentLevel;
    }

    public abstract void processToken(String var1);

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void toBrokenList(StringBuilder result, double[] data) {
        int lineCount = 0;
        result.setLength(0);
        int i = 0;
        while (i < data.length) {
            if (i != 0) {
                result.append(',');
            }
            if (++lineCount > 10) {
                result.append("\n");
                lineCount = 0;
            }
            result.append(CSVFormat.EG_FORMAT.format(data[i], 10));
            ++i;
        }
    }

    public void toBrokenList(StringBuilder result, int[] data) {
        int lineCount = 0;
        int i = 0;
        while (i < data.length) {
            if (i != 0) {
                result.append(',');
            }
            if (++lineCount > 10) {
                result.append("\n");
                lineCount = 0;
            }
            result.append("" + data[i]);
            ++i;
        }
    }

    @Override
    public void writeContents(File targetFile) {
        try {
            FileWriter outFile = new FileWriter(targetFile);
            PrintWriter out = new PrintWriter(outFile);
            out.print(this.contents.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

