/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.script;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.script.AnalystClassItem;
import org.encog.app.analyst.script.AnalystScript;
import org.encog.app.analyst.script.DataField;
import org.encog.app.analyst.script.ml.ScriptOpcode;
import org.encog.app.analyst.script.normalize.AnalystField;
import org.encog.app.analyst.script.process.ProcessField;
import org.encog.app.analyst.script.prop.PropertyConstraints;
import org.encog.app.analyst.script.prop.PropertyEntry;
import org.encog.app.analyst.script.segregate.AnalystSegregateTarget;
import org.encog.app.analyst.script.task.AnalystTask;
import org.encog.persist.EncogWriteHelper;

public class ScriptSave {
    private final AnalystScript script;

    public ScriptSave(AnalystScript theScript) {
        this.script = theScript;
    }

    public void save(OutputStream stream) {
        EncogWriteHelper out = new EncogWriteHelper(stream);
        this.saveSubSection(out, "HEADER", "DATASOURCE");
        this.saveConfig(out);
        if (this.script.getFields() != null) {
            this.saveData(out);
            this.saveNormalize(out);
        }
        this.saveProcess(out);
        this.saveSubSection(out, "RANDOMIZE", "CONFIG");
        this.saveSubSection(out, "CLUSTER", "CONFIG");
        this.saveSubSection(out, "BALANCE", "CONFIG");
        this.saveSubSection(out, "CODE", "CONFIG");
        if (this.script.getSegregate().getSegregateTargets() != null) {
            this.saveSegregate(out);
        }
        this.saveSubSection(out, "GENERATE", "CONFIG");
        this.saveMachineLearning(out);
        this.saveTasks(out);
        out.flush();
    }

    private void saveProcess(EncogWriteHelper out) {
        this.saveSubSection(out, "PROCESS", "CONFIG");
        out.addSubSection("FIELDS");
        out.addColumn("name");
        out.addColumn("command");
        out.writeLine();
        for (ProcessField field : this.script.getProcess().getFields()) {
            out.addColumn(field.getName());
            out.addColumn(field.getCommand());
            out.writeLine();
        }
        out.flush();
    }

    private void saveConfig(EncogWriteHelper out) {
        this.saveSubSection(out, "SETUP", "CONFIG");
        out.addSubSection("FILENAMES");
        List<String> list = this.script.getProperties().getFilenames();
        for (String key : list) {
            String value = this.script.getProperties().getFilename(key);
            File f = new File(value);
            if (f.getParent() != null && f.getParent().equalsIgnoreCase(this.script.getBasePath())) {
                out.writeProperty(key, f.getName());
                continue;
            }
            out.writeProperty(key, value);
        }
    }

    private void saveData(EncogWriteHelper out) {
        DataField field;
        this.saveSubSection(out, "DATA", "CONFIG");
        out.addSubSection("STATS");
        out.addColumn("name");
        out.addColumn("isclass");
        out.addColumn("iscomplete");
        out.addColumn("isint");
        out.addColumn("isreal");
        out.addColumn("amax");
        out.addColumn("amin");
        out.addColumn("mean");
        out.addColumn("sdev");
        out.addColumn("source");
        out.writeLine();
        DataField[] dataFieldArray = this.script.getFields();
        int n = dataFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = dataFieldArray[n2];
            out.addColumn(field.getName());
            out.addColumn(field.isClass());
            out.addColumn(field.isComplete());
            out.addColumn(field.isInteger());
            out.addColumn(field.isReal());
            out.addColumn(field.getMax());
            out.addColumn(field.getMin());
            out.addColumn(field.getMean());
            out.addColumn(field.getStandardDeviation());
            out.addColumn(field.getSource());
            out.writeLine();
            ++n2;
        }
        out.flush();
        out.addSubSection("CLASSES");
        out.addColumn("field");
        out.addColumn("code");
        out.addColumn("name");
        out.addColumn("count");
        out.writeLine();
        dataFieldArray = this.script.getFields();
        n = dataFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            field = dataFieldArray[n2];
            if (field.isClass()) {
                for (AnalystClassItem col : field.getClassMembers()) {
                    out.addColumn(field.getName());
                    out.addColumn(col.getCode());
                    out.addColumn(col.getName());
                    out.addColumn(col.getCount());
                    out.writeLine();
                }
            }
            ++n2;
        }
    }

    private void saveMachineLearning(EncogWriteHelper out) {
        this.saveSubSection(out, "ML", "CONFIG");
        this.saveSubSection(out, "ML", "TRAIN");
        out.addSubSection("OPCODES");
        out.addColumn("code");
        out.addColumn("count");
        out.writeLine();
        for (ScriptOpcode so : this.script.getOpcodes()) {
            out.addColumn(so.getName());
            out.addColumn(so.getArgCount());
            out.writeLine();
        }
    }

    private void saveNormalize(EncogWriteHelper out) {
        this.saveSubSection(out, "NORMALIZE", "CONFIG");
        out.addSubSection("RANGE");
        out.addColumn("name");
        out.addColumn("io");
        out.addColumn("timeSlice");
        out.addColumn("action");
        out.addColumn("high");
        out.addColumn("low");
        out.writeLine();
        for (AnalystField field : this.script.getNormalize().getNormalizedFields()) {
            out.addColumn(field.getName());
            if (field.isInput()) {
                out.addColumn("input");
            } else {
                out.addColumn("output");
            }
            out.addColumn(field.getTimeSlice());
            switch (field.getAction()) {
                case Ignore: {
                    out.addColumn("ignore");
                    break;
                }
                case Normalize: {
                    out.addColumn("range");
                    break;
                }
                case PassThrough: {
                    out.addColumn("pass");
                    break;
                }
                case OneOf: {
                    out.addColumn("oneof");
                    break;
                }
                case Equilateral: {
                    out.addColumn("equilateral");
                    break;
                }
                case SingleField: {
                    out.addColumn("single");
                    break;
                }
                default: {
                    throw new AnalystError("Unknown action: " + (Object)((Object)field.getAction()));
                }
            }
            out.addColumn(field.getNormalizedHigh());
            out.addColumn(field.getNormalizedLow());
            out.writeLine();
        }
    }

    private void saveSegregate(EncogWriteHelper out) {
        this.saveSubSection(out, "SEGREGATE", "CONFIG");
        out.addSubSection("FILES");
        out.addColumn("file");
        out.addColumn("percent");
        out.writeLine();
        AnalystSegregateTarget[] analystSegregateTargetArray = this.script.getSegregate().getSegregateTargets();
        int n = analystSegregateTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalystSegregateTarget target = analystSegregateTargetArray[n2];
            out.addColumn(target.getFile());
            out.addColumn(target.getPercent());
            out.writeLine();
            ++n2;
        }
    }

    private void saveSubSection(EncogWriteHelper out, String section, String subSection) {
        if (!section.equals(out.getCurrentSection())) {
            out.addSection(section);
        }
        out.addSubSection(subSection);
        List<PropertyEntry> list = PropertyConstraints.getInstance().getEntries(section, subSection);
        if (list != null) {
            Collections.sort(list);
            for (PropertyEntry entry : list) {
                String key = String.valueOf(section) + ":" + subSection + "_" + entry.getName();
                String value = this.script.getProperties().getPropertyString(key);
                if (value != null) {
                    out.writeProperty(entry.getName(), value);
                    continue;
                }
                out.writeProperty(entry.getName(), "");
            }
        }
    }

    private void saveTasks(EncogWriteHelper out) {
        out.addSection("TASKS");
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.script.getTasks().keySet());
        Collections.sort(list);
        for (String key : list) {
            AnalystTask task = this.script.getTask(key);
            out.addSubSection(task.getName());
            for (String line : task.getLines()) {
                out.addLine(line);
            }
        }
    }
}

