/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.sort;

import java.util.Comparator;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.app.analyst.csv.sort.SortCSV;
import org.encog.app.analyst.csv.sort.SortedField;
import org.encog.app.quant.QuantError;

public class RowComparator
implements Comparator<LoadedRow> {
    private final SortCSV sort;

    public RowComparator(SortCSV owner) {
        this.sort = owner;
    }

    @Override
    public int compare(LoadedRow x, LoadedRow y) {
        block5: for (SortedField t : this.sort.getSortOrder()) {
            int index = t.getIndex();
            String xStr = x.getData()[index];
            String yStr = y.getData()[index];
            switch (t.getSortType()) {
                case SortDecimal: {
                    double xDouble = this.sort.getFormat().parse(xStr);
                    double yDouble = this.sort.getFormat().parse(yStr);
                    int c = Double.compare(xDouble, yDouble);
                    if (c == 0) continue block5;
                    return c;
                }
                case SortInteger: {
                    int xInteger = Integer.parseInt(xStr);
                    int yInteger = Integer.parseInt(yStr);
                    int c2 = xInteger - yInteger;
                    if (c2 == 0) continue block5;
                    return c2;
                }
                case SortString: {
                    int c3 = xStr.compareTo(yStr);
                    if (c3 == 0) continue block5;
                    return c3;
                }
                default: {
                    throw new QuantError("Unknown sort method: " + (Object)((Object)t.getSortType()));
                }
            }
        }
        return 0;
    }
}

