/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.BasicTemplate;
import org.encog.ml.prg.extension.EncogOpcodeRegistry;
import org.encog.ml.prg.extension.FunctionFactory;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class ProcessExtension {
    public static final String EXTENSION_DATA_NAME = "ENCOG-ANALYST-PROCESS";
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private int forwardWindowSize;
    private int backwardWindowSize;
    private int totalWindowSize;
    private List<LoadedRow> data = new ArrayList<LoadedRow>();
    private final CSVFormat format;
    public static final ProgramExtensionTemplate OPCODE_FIELD = new BasicTemplate(100, "field({s}{i}):{s}", NodeType.Function, true, 0){
        private static final long serialVersionUID = 1L;

        @Override
        public ExpressionValue evaluate(ProgramNode actual) {
            ProcessExtension pe = (ProcessExtension)actual.getOwner().getExtraData(ProcessExtension.EXTENSION_DATA_NAME);
            String fieldName = actual.getChildNode(0).evaluate().toStringValue();
            int fieldIndex = (int)actual.getChildNode(1).evaluate().toFloatValue() + pe.getBackwardWindowSize();
            String value = pe.getField(fieldName, fieldIndex);
            return new ExpressionValue(value);
        }
    };
    public static final ProgramExtensionTemplate OPCODE_FIELDMAX = new BasicTemplate(100, "fieldmax({s}{i}{i}):{f}", NodeType.Function, true, 0){
        private static final long serialVersionUID = 1L;

        @Override
        public ExpressionValue evaluate(ProgramNode actual) {
            ProcessExtension pe = (ProcessExtension)actual.getOwner().getExtraData(ProcessExtension.EXTENSION_DATA_NAME);
            String fieldName = actual.getChildNode(0).evaluate().toStringValue();
            int startIndex = (int)actual.getChildNode(1).evaluate().toIntValue();
            int stopIndex = (int)actual.getChildNode(2).evaluate().toIntValue();
            double value = Double.NEGATIVE_INFINITY;
            int i = startIndex;
            while (i <= stopIndex) {
                String str = pe.getField(fieldName, pe.getBackwardWindowSize() + i);
                double d = pe.getFormat().parse(str);
                value = Math.max(d, value);
                ++i;
            }
            return new ExpressionValue(value);
        }
    };
    public static final ProgramExtensionTemplate OPCODE_FIELDMAXPIP = new BasicTemplate(100, "fieldmaxpip({s}{i}{i}):{f}", NodeType.Function, true, 0){
        private static final long serialVersionUID = 1L;

        @Override
        public ExpressionValue evaluate(ProgramNode actual) {
            ProcessExtension pe = (ProcessExtension)actual.getOwner().getExtraData(ProcessExtension.EXTENSION_DATA_NAME);
            String fieldName = actual.getChildNode(0).evaluate().toStringValue();
            int startIndex = (int)actual.getChildNode(1).evaluate().toIntValue();
            int stopIndex = (int)actual.getChildNode(2).evaluate().toIntValue();
            int value = Integer.MIN_VALUE;
            String str = pe.getField(fieldName, pe.getBackwardWindowSize());
            double quoteNow = pe.getFormat().parse(str);
            int i = startIndex;
            while (i <= stopIndex) {
                str = pe.getField(fieldName, pe.getBackwardWindowSize() + i);
                double d = pe.getFormat().parse(str) - quoteNow;
                d /= 1.0E-4;
                d = Math.round(d);
                value = Math.max((int)d, value);
                ++i;
            }
            return new ExpressionValue(value);
        }
    };

    static {
        EncogOpcodeRegistry.INSTANCE.add(OPCODE_FIELD);
        EncogOpcodeRegistry.INSTANCE.add(OPCODE_FIELDMAX);
        EncogOpcodeRegistry.INSTANCE.add(OPCODE_FIELDMAXPIP);
    }

    public ProcessExtension(CSVFormat theFormat) {
        this.format = theFormat;
    }

    public String getField(String fieldName, int fieldIndex) {
        if (!this.map.containsKey(fieldName)) {
            throw new AnalystError("Unknown input field: " + fieldName);
        }
        int idx = this.map.get(fieldName);
        if (fieldIndex >= this.data.size() || fieldIndex < 0) {
            throw new AnalystError("The specified temporal index " + fieldIndex + " is out of bounds.  You should probably increase the forward window size.");
        }
        return this.data.get(fieldIndex).getData()[idx];
    }

    public void loadRow(LoadedRow row) {
        this.data.add(0, row);
        if (this.data.size() > this.totalWindowSize) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public void init(ReadCSV csv, int theBackwardWindowSize, int theForwardWindowSize) {
        this.forwardWindowSize = theForwardWindowSize;
        this.backwardWindowSize = theBackwardWindowSize;
        this.totalWindowSize = this.forwardWindowSize + this.backwardWindowSize + 1;
        int i = 0;
        for (String name : csv.getColumnNames()) {
            this.map.put(name, i++);
        }
    }

    public boolean isDataReady() {
        return this.data.size() >= this.totalWindowSize;
    }

    public int getForwardWindowSize() {
        return this.forwardWindowSize;
    }

    public int getBackwardWindowSize() {
        return this.backwardWindowSize;
    }

    public int getTotalWindowSize() {
        return this.totalWindowSize;
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public void register(FunctionFactory functions) {
        functions.addExtension(OPCODE_FIELD);
        functions.addExtension(OPCODE_FIELDMAX);
        functions.addExtension(OPCODE_FIELDMAXPIP);
    }
}

