/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.analyst.csv.balance;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.encog.app.analyst.csv.basic.BasicFile;
import org.encog.app.analyst.csv.basic.LoadedRow;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;

public class BalanceCSV
extends BasicFile {
    private Map<String, Integer> counts;

    public void analyze(File inputFile, boolean headers, CSVFormat format) {
        this.setInputFilename(inputFile);
        this.setExpectInputHeaders(headers);
        this.setInputFormat(format);
        this.setAnalyzed(true);
        this.performBasicCounts();
    }

    public String dumpCounts() {
        StringBuilder result = new StringBuilder();
        for (String key : this.counts.keySet()) {
            result.append(key);
            result.append(" : ");
            result.append(this.counts.get(key));
            result.append("\n");
        }
        return result.toString();
    }

    public Map<String, Integer> getCounts() {
        return this.counts;
    }

    public void process(File outputFile, int targetField, int countPer) {
        this.validateAnalyzed();
        PrintWriter tw = this.prepareOutputFile(outputFile);
        this.counts = new HashMap<String, Integer>();
        ReadCSV csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
        this.resetStatus();
        while (csv.next() && !this.shouldStop()) {
            LoadedRow row = new LoadedRow(csv);
            this.updateStatus(false);
            String key = row.getData()[targetField];
            int count = !this.counts.containsKey(key) ? 0 : this.counts.get(key);
            if (count < countPer) {
                this.writeRow(tw, row);
                ++count;
            }
            this.counts.put(key, count);
        }
        this.reportDone(false);
        csv.close();
        tw.close();
    }
}

