/*
 * Decompiled with CFR 0.152.
 */
package org.encog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.encog.EncogShutdownTask;
import org.encog.mathutil.randomize.factory.BasicRandomFactory;
import org.encog.mathutil.randomize.factory.RandomFactory;
import org.encog.plugin.EncogPluginBase;
import org.encog.plugin.EncogPluginLogging1;
import org.encog.plugin.system.SystemActivationPlugin;
import org.encog.plugin.system.SystemLoggingPlugin;
import org.encog.plugin.system.SystemMethodsPlugin;
import org.encog.plugin.system.SystemTrainingPlugin;
import org.encog.util.concurrency.EngineConcurrency;

public final class Encog {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String VERSION = "3.4.0";
    public static final String COPYRIGHT = "Copyright 2014 by Heaton Research, Inc.";
    public static final String LICENSE = "Open Source under the Apache License";
    private static final String FILE_VERSION = "1";
    public static final int DEFAULT_PRECISION = 10;
    public static final double DEFAULT_DOUBLE_EQUAL = 1.0E-13;
    public static final String ENCOG_VERSION = "encog.version";
    public static final String ENCOG_FILE_VERSION = "encog.file.version";
    private RandomFactory randomFactory = new BasicRandomFactory();
    private Set<EncogShutdownTask> shutdownTasks = new HashSet<EncogShutdownTask>();
    private static Encog instance = new Encog();
    private EncogPluginLogging1 loggingPlugin;
    private final List<EncogPluginBase> plugins = new ArrayList<EncogPluginBase>();
    private final Map<String, String> properties = new HashMap<String, String>();

    public static Encog getInstance() {
        return instance;
    }

    private Encog() {
        this.properties.put(ENCOG_VERSION, VERSION);
        this.properties.put(ENCOG_FILE_VERSION, FILE_VERSION);
        this.registerPlugin(new SystemLoggingPlugin());
        this.registerPlugin(new SystemMethodsPlugin());
        this.registerPlugin(new SystemTrainingPlugin());
        this.registerPlugin(new SystemActivationPlugin());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void registerPlugin(EncogPluginBase plugin) {
        if (plugin.getPluginServiceType() != 0 && plugin.getPluginServiceType() == 1) {
            if (this.loggingPlugin != null) {
                this.plugins.remove(this.loggingPlugin);
            }
            this.loggingPlugin = (EncogPluginLogging1)plugin;
        }
        this.plugins.add(plugin);
    }

    public void unregisterPlugin(EncogPluginBase plugin) {
        if (plugin == this.loggingPlugin) {
            this.loggingPlugin = new SystemLoggingPlugin();
        }
        this.plugins.remove(plugin);
    }

    public void shutdown() {
        while (this.shutdownTasks.size() > 0) {
            Object[] list = this.shutdownTasks.toArray();
            int i = 0;
            while (i < list.length) {
                EncogShutdownTask task = (EncogShutdownTask)list[i];
                this.shutdownTasks.remove(task);
                task.performShutdownTask();
                ++i;
            }
        }
        EngineConcurrency.getInstance().shutdown(10000L);
    }

    public EncogPluginLogging1 getLoggingPlugin() {
        return this.loggingPlugin;
    }

    public Collection<EncogPluginBase> getPlugins() {
        return this.plugins;
    }

    public static boolean isOSX() {
        String osName = System.getProperty("os.name");
        return osName.contains("OS X");
    }

    public RandomFactory getRandomFactory() {
        return this.randomFactory;
    }

    public void setRandomFactory(RandomFactory randomFactory) {
        this.randomFactory = randomFactory;
    }

    public void addShutdownTask(EncogShutdownTask task) {
        this.shutdownTasks.add(task);
    }

    public void removeShutdownTask(EncogShutdownTask task) {
        this.shutdownTasks.remove(task);
    }
}

