/*
 * Decompiled with CFR 0.152.
 */
package org.dmelt;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import jehep.ui.mainGUI;

public class Main {
    private static ArrayList<String> jarlist;

    public static void main(String[] args) {
        boolean goodVM = true;
        String ver = System.getProperty("java.version").substring(0, 3);
        if (ver.indexOf("1.3") > -1) {
            goodVM = false;
        }
        if (ver.indexOf("1.4") > -1) {
            goodVM = false;
        }
        if (ver.indexOf("1.5") > -1) {
            goodVM = false;
        }
        if (ver.indexOf("1.6") > -1) {
            goodVM = false;
        }
        if (!goodVM) {
            JOptionPane.showMessageDialog(null, "DataMelt requires Java 7 or later.");
            System.exit(0);
        }
        String fSep = System.getProperty("file.separator");
        Path currentRelativePath = Paths.get("", new String[0]);
        String DirPath = currentRelativePath.toAbsolutePath().toString();
        jarlist = new ArrayList();
        String ROOT = DirPath + fSep + "lib";
        ProcessFile fileProcessor = new ProcessFile();
        try {
            Files.walkFileTree(Paths.get(ROOT, new String[0]), fileProcessor);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < jarlist.size(); ++i) {
            try {
                Main.addFile(jarlist.get(i));
                continue;
            }
            catch (Exception e) {
                System.out.println("Cannot add jar file:" + jarlist.get(i));
            }
        }
        System.setProperty("python.home", DirPath + fSep + "lib" + fSep + "jython");
        System.setProperty("jehep.home", DirPath);
        System.setProperty("log4j.configuration", DirPath + fSep + "log4j.properties");
        try {
            Main.addLibraryPath(DirPath + fSep + "lib" + fSep + "native" + fSep + "windows-amd64");
            Main.addLibraryPath(DirPath + fSep + "lib" + fSep + "native" + fSep + "windows-i586");
            Main.addLibraryPath(DirPath + fSep + "lib" + fSep + "native" + fSep + "linux-amd64");
            Main.addLibraryPath(DirPath + fSep + "lib" + fSep + "native" + fSep + "linux-i586");
            Main.addLibraryPath(DirPath + fSep + "lib" + fSep + "native" + fSep + "macosx");
        }
        catch (Exception e) {
            System.out.println("Cannot find native library path");
        }
        mainGUI.main(args);
    }

    public static void addFile(String moduleFile) throws IOException {
        File mFile = new File(moduleFile);
        URL moduleURL = mFile.toURL();
        Class[] parameters = new Class[]{URL.class};
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, moduleURL);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }

    private static final class ProcessFile
    extends SimpleFileVisitor<Path> {
        private ProcessFile() {
        }

        @Override
        public FileVisitResult visitFile(Path aFile, BasicFileAttributes aAttrs) throws IOException {
            String fs = aFile.toFile().getAbsolutePath();
            if (fs.endsWith(".jar")) {
                jarlist.add(fs);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path aDir, BasicFileAttributes aAttrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

