/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sharptools.Cell;
import sharptools.Config;
import sharptools.Debug;
import sharptools.EditOp;
import sharptools.FileOp;
import sharptools.Formula;
import sharptools.HelpOp;
import sharptools.Histogram;
import sharptools.History;
import sharptools.SharpCellEditor;
import sharptools.SharpCellRenderer;
import sharptools.SharpOptionPane;
import sharptools.SharpTableModel;
import sharptools.TableOp;

public final class SharpTools
extends JFrame
implements ListSelectionListener {
    protected int maxNumPage = 1;
    private Container container;
    private JTable table;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JMenuBar menuBar;
    private JPanel barPanel;
    private History history;
    private Histogram histogram;
    public static Config config;
    private SharpTableModel tableModel;
    private ListSelectionModel rowSelectionModel;
    private ListSelectionModel columnSelectionModel;
    private URL url;
    private FileOp fileOp;
    private EditOp editOp;
    private TableOp tableOp;
    private JMenu fileMenu;
    private JMenu openMenu;
    private JMenu recentMenu;
    private JMenu editMenu;
    private JMenu tableMenu;
    private JMenu chartMenu;
    private JMenu helpMenu;
    private JMenu insertMenu;
    private JMenu deleteMenu;
    private JMenu sortMenu;
    private JMenuItem saveMenuItem;
    private JCheckBoxMenuItem saveOnExitMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem findNextMenuItem;
    private JCheckBoxMenuItem showHistogramMenuItem;
    private JCheckBoxMenuItem showFunctionsMenuItem;
    private JButton saveButton;
    private JButton passwordButton;
    private JButton undoButton;
    private JButton redoButton;
    private JComponent funcList;
    private final ImageIcon newIcon = SharpTools.getImageIcon("new.gif");
    private final ImageIcon openIcon = SharpTools.getImageIcon("open.gif");
    private final ImageIcon saveIcon = SharpTools.getImageIcon("save.gif");
    private final ImageIcon unlockedIcon = SharpTools.getImageIcon("unlocked.gif");
    private final ImageIcon lockedIcon = SharpTools.getImageIcon("locked.gif");
    private final ImageIcon printIcon = SharpTools.getImageIcon("print.gif");
    private final ImageIcon undoIcon = SharpTools.getImageIcon("undo.gif");
    private final ImageIcon redoIcon = SharpTools.getImageIcon("redo.gif");
    private final ImageIcon cutIcon = SharpTools.getImageIcon("cut.gif");
    private final ImageIcon copyIcon = SharpTools.getImageIcon("copy.gif");
    private final ImageIcon pasteIcon = SharpTools.getImageIcon("paste.gif");
    private final ImageIcon findIcon = SharpTools.getImageIcon("find.gif");
    private final ImageIcon insertRowIcon = SharpTools.getImageIcon("insertrow.gif");
    private final ImageIcon insertColumnIcon = SharpTools.getImageIcon("insertcolumn.gif");
    private final ImageIcon deleteRowIcon = SharpTools.getImageIcon("deleterow.gif");
    private final ImageIcon deleteColumnIcon = SharpTools.getImageIcon("deletecolumn.gif");
    private final ImageIcon sortIcon = SharpTools.getImageIcon("sort.gif");
    private final ImageIcon chartIcon = SharpTools.getImageIcon("chart.gif");
    private final ImageIcon helpIcon = SharpTools.getImageIcon("help.gif");
    public static int baseRow;
    public static int baseCol;

    public static Config getConfig() {
        return config;
    }

    public History getHistory() {
        return this.history;
    }

    public JTable getTable() {
        return this.table;
    }

    public SharpTableModel getTableModel() {
        return this.tableModel;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public SharpTools() {
        super("Spreadsheet");
        config = new Config("sharptools.ini");
        config.setInt("ROWS", 30);
        config.setInt("COLUMNS", 7);
        config.setInt("HISTOGRAMWIDTH", 600);
        config.setInt("HISTOGRAMHEIGHT", 400);
        config.setBoolean("TOOLBAR_NEW", true);
        config.setBoolean("TOOLBAR_OPEN", true);
        config.setBoolean("TOOLBAR_SAVE", true);
        config.setBoolean("TOOLBAR_PRINT", true);
        config.setBoolean("TOOLBAR_UNDO", true);
        config.setBoolean("TOOLBAR_REDO", true);
        config.setBoolean("TOOLBAR_CUT", true);
        config.setBoolean("TOOLBAR_COPY", true);
        config.setBoolean("TOOLBAR_PASTE", true);
        config.setBoolean("TOOLBAR_FIND", true);
        config.setBoolean("TOOLBAR_INSERTROW", true);
        config.setBoolean("TOOLBAR_INSERTCOLUMN", true);
        config.setBoolean("TOOLBAR_DELETEROW", true);
        config.setBoolean("TOOLBAR_DELETECOLUMN", true);
        config.setBoolean("TOOLBAR_FUNCTIONS", true);
        config.load();
        if (config.get("DEBUG") != null) {
            Debug.setDebug(config.getBoolean("DEBUG"));
        }
        Formula.registerFunctions();
        this.build(config);
    }

    public SharpTools(Config conf) {
        super("Spreadsheet");
        config = conf;
        config.setInt("ROWS", 20);
        config.setInt("COLUMNS", 10);
        config.setInt("HISTOGRAMWIDTH", 600);
        config.setInt("HISTOGRAMHEIGHT", 400);
        config.load();
        if (config.get("DEBUG") != null) {
            Debug.setDebug(config.getBoolean("DEBUG"));
        }
        Formula.registerFunctions();
        this.build(config);
    }

    public void build(final Config config) {
        int x = config.getInt("X");
        int y = config.getInt("Y");
        Dimension scrdim = this.getToolkit().getScreenSize();
        if (x >= 0 && y >= 0 && x < (int)scrdim.getWidth() && y < (int)scrdim.getHeight()) {
            this.setLocation(x, y);
        }
        this.setDefaultCloseOperation(0);
        this.container = this.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.table = new JTable();
        this.funcList = HelpOp.createFunctionListComponent(this, this.table);
        this.fileMenu = new JMenu("File", true);
        this.fileMenu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem("New...");
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.newFile();
            }
        });
        this.fileMenu.add(menuItem);
        this.openMenu = new JMenu("Open");
        this.openMenu.setMnemonic(79);
        menuItem = new JMenuItem("File...");
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.openFile();
            }
        });
        this.openMenu.add(menuItem);
        menuItem = new JMenuItem("Database...");
        menuItem.setMnemonic(68);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.openDb();
            }
        });
        this.openMenu.add(menuItem);
        this.fileMenu.add(this.openMenu);
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.setMnemonic(83);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.saveFile();
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        menuItem = new JMenuItem("Save As...");
        menuItem.setMnemonic(65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.saveAsFile();
            }
        });
        this.fileMenu.add(menuItem);
        menuItem = new JMenuItem("Set Password...");
        menuItem.setMnemonic(69);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.setPassword();
                SharpTools.this.checkPasswordState();
            }
        });
        this.fileMenu.add(menuItem);
        this.fileMenu.addSeparator();
        menuItem = new JMenuItem("Print...");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Thread runner = new Thread(){

                    @Override
                    public void run() {
                        SharpTools.this.fileOp.printData();
                    }
                };
                runner.start();
            }
        });
        this.fileMenu.add(menuItem);
        this.fileMenu.addSeparator();
        this.recentMenu = new JMenu("Recent Files");
        this.recentMenu.setMnemonic(82);
        this.recentMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                SharpTools.this.fileOp.createRecentFilesMenu(SharpTools.this.recentMenu);
            }
        });
        this.fileMenu.add(this.recentMenu);
        this.fileMenu.addSeparator();
        this.saveOnExitMenuItem = new JCheckBoxMenuItem("Save Window on Exit");
        this.saveOnExitMenuItem.setMnemonic(87);
        this.saveOnExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                config.setBoolean("SAVEWINDOW", SharpTools.this.saveOnExitMenuItem.isSelected());
            }
        });
        this.saveOnExitMenuItem.setSelected(config.getBoolean("SAVEWINDOW"));
        this.fileMenu.add(this.saveOnExitMenuItem);
        this.fileMenu.addSeparator();
        menuItem = new JMenuItem("Exit");
        menuItem.setMnemonic(88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.exit();
            }
        });
        this.fileMenu.add(menuItem);
        this.editMenu = new JMenu("Edit", true);
        this.editMenu.setMnemonic(69);
        this.undoMenuItem = new JMenuItem("Undo");
        this.undoMenuItem.setMnemonic(85);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem = new JMenuItem("Redo");
        this.redoMenuItem.setMnemonic(82);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem("Cut");
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.cut();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem("Copy");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.copy();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem("Paste");
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.paste();
            }
        });
        this.editMenu.add(menuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem("Fill...");
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.fill();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem("Clear");
        menuItem.setMnemonic(76);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0, true));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.clear();
            }
        });
        this.editMenu.add(menuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem("Find...");
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(true);
            }
        });
        this.editMenu.add(menuItem);
        this.findNextMenuItem = new JMenuItem("Find Next");
        this.findNextMenuItem.setMnemonic(78);
        this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.findNextMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(false);
            }
        });
        this.editMenu.add(this.findNextMenuItem);
        this.tableMenu = new JMenu("Table", true);
        this.tableMenu.setMnemonic(84);
        this.insertMenu = new JMenu("Insert");
        this.insertMenu.setMnemonic(73);
        menuItem = new JMenuItem("Row");
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(true);
            }
        });
        this.insertMenu.add(menuItem);
        menuItem = new JMenuItem("Column");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(155, 3));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(false);
            }
        });
        this.insertMenu.add(menuItem);
        this.tableMenu.add(this.insertMenu);
        this.deleteMenu = new JMenu("Delete");
        this.deleteMenu.setMnemonic(68);
        menuItem = new JMenuItem("Row");
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(true);
            }
        });
        this.deleteMenu.add(menuItem);
        menuItem = new JMenuItem("Column");
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 3));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(false);
            }
        });
        this.deleteMenu.add(menuItem);
        this.tableMenu.add(this.deleteMenu);
        this.tableMenu.addSeparator();
        this.sortMenu = new JMenu("Sort");
        this.sortMenu.setMnemonic(83);
        menuItem = new JMenuItem("Row...");
        menuItem.setMnemonic(82);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(true);
            }
        });
        this.sortMenu.add(menuItem);
        menuItem = new JMenuItem("Column...");
        menuItem.setMnemonic(67);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(false);
            }
        });
        this.sortMenu.add(menuItem);
        this.tableMenu.add(this.sortMenu);
        this.tableMenu.addSeparator();
        menuItem = new JMenuItem("Set Column Width...");
        menuItem.setMnemonic(87);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.setColumnWidth();
            }
        });
        this.tableMenu.add(menuItem);
        this.chartMenu = new JMenu("Chart", true);
        this.chartMenu.setMnemonic(67);
        this.chartMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                SharpTools.this.checkShowHistogramState();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.showHistogramMenuItem = new JCheckBoxMenuItem("Show");
        this.showHistogramMenuItem.setMnemonic(83);
        this.showHistogramMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.showHistogramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.toggle();
            }
        });
        this.chartMenu.add(this.showHistogramMenuItem);
        menuItem = new JMenuItem("Histogram...");
        menuItem.setMnemonic(72);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.addHistogram();
            }
        });
        this.chartMenu.add(menuItem);
        this.tableMenu.add(this.chartMenu);
        this.helpMenu = new JMenu("Help", true);
        this.helpMenu.setMnemonic(72);
        menuItem = new JMenuItem("Help Topics");
        menuItem.setMnemonic(72);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    URL url = new URL("http://jwork.org/jhepwork/doc/sharptools/manual/index.html");
                    new HelpOp(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        this.helpMenu.add(menuItem);
        this.showFunctionsMenuItem = new JCheckBoxMenuItem("Show Functions");
        this.showFunctionsMenuItem.setMnemonic(83);
        this.showFunctionsMenuItem.setSelected(config.getBoolean("TOOLBAR_FUNCTIONS"));
        this.showFunctionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean showFunc = SharpTools.this.showFunctionsMenuItem.isSelected();
                config.setBoolean("TOOLBAR_FUNCTIONS", showFunc);
                SharpTools.this.funcList.setVisible(showFunc);
            }
        });
        this.helpMenu.add(this.showFunctionsMenuItem);
        this.helpMenu.addSeparator();
        menuItem = new JMenuItem("About..");
        menuItem.setMnemonic(65);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpOp.showAboutBox(SharpTools.this);
                SharpTools.this.table.requestFocus();
            }
        });
        this.helpMenu.add(menuItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.tableMenu);
        this.menuBar.add(this.chartMenu);
        this.menuBar.add(this.helpMenu);
        JButton newButton = new JButton(this.newIcon);
        newButton.setToolTipText("New");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.newFile();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton openButton = new JButton(this.openIcon);
        openButton.setToolTipText("Open");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.openFile();
                SharpTools.this.table.requestFocus();
            }
        });
        this.saveButton = new JButton(this.saveIcon);
        this.saveButton.setToolTipText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.saveFile();
                SharpTools.this.table.requestFocus();
            }
        });
        this.passwordButton = new JButton(this.unlockedIcon);
        this.passwordButton.setToolTipText("Set Password");
        this.passwordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.fileOp.setPassword();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton printButton = new JButton(this.printIcon);
        printButton.setToolTipText("Print");
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Thread runner = new Thread(){

                    @Override
                    public void run() {
                        SharpTools.this.fileOp.printData();
                    }
                };
                runner.start();
                SharpTools.this.table.requestFocus();
            }
        });
        this.undoButton = new JButton(this.undoIcon);
        this.undoButton.setToolTipText("Undo");
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        this.redoButton = new JButton(this.redoIcon);
        this.redoButton.setToolTipText("Redo");
        this.redoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton cutButton = new JButton(this.cutIcon);
        cutButton.setToolTipText("Cut");
        cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.cut();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton copyButton = new JButton(this.copyIcon);
        copyButton.setToolTipText("Copy");
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.copy();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton pasteButton = new JButton(this.pasteIcon);
        pasteButton.setToolTipText("Paste");
        pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.paste();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton findButton = new JButton(this.findIcon);
        findButton.setToolTipText("Find");
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton sortButton = new JButton(this.sortIcon);
        sortButton.setToolTipText("Sort by Column");
        sortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton insertRowButton = new JButton(this.insertRowIcon);
        insertRowButton.setToolTipText("Insert Row");
        insertRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton insertColumnButton = new JButton(this.insertColumnIcon);
        insertColumnButton.setToolTipText("Insert Column");
        insertColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton deleteRowButton = new JButton(this.deleteRowIcon);
        deleteRowButton.setToolTipText("Delete Row");
        deleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton deleteColumnButton = new JButton(this.deleteColumnIcon);
        deleteColumnButton.setToolTipText("Delete Column");
        deleteColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton chartButton = new JButton(this.chartIcon);
        chartButton.setToolTipText("Histogram");
        chartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.addHistogram();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton helpButton = new JButton(this.helpIcon);
        helpButton.setToolTipText("Help");
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String basePath = System.getProperty("user.dir");
                    SharpTools.this.url = new URL("http://jwork.org/jhepwork/doc/sharptools/manual/index.html");
                    new HelpOp(SharpTools.this.url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                SharpTools.this.table.requestFocus();
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        if (config.getBoolean("TOOLBAR_NEW")) {
            this.toolBar.add(newButton);
        }
        if (config.getBoolean("TOOLBAR_OPEN")) {
            this.toolBar.add(openButton);
        }
        if (config.getBoolean("TOOLBAR_SAVE")) {
            this.toolBar.add(this.saveButton);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_PASSWORD")) {
            this.toolBar.add(this.passwordButton);
        }
        if (config.getBoolean("TOOLBAR_PRINT")) {
            this.toolBar.add(printButton);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_UNDO")) {
            this.toolBar.add(this.undoButton);
        }
        if (config.getBoolean("TOOLBAR_REDO")) {
            this.toolBar.add(this.redoButton);
        }
        if (config.getBoolean("TOOLBAR_CUT")) {
            this.toolBar.add(cutButton);
        }
        if (config.getBoolean("TOOLBAR_COPY")) {
            this.toolBar.add(copyButton);
        }
        if (config.getBoolean("TOOLBAR_PASTE")) {
            this.toolBar.add(pasteButton);
        }
        if (config.getBoolean("TOOLBAR_FIND")) {
            this.toolBar.add(findButton);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_INSERTROW")) {
            this.toolBar.add(insertRowButton);
        }
        if (config.getBoolean("TOOLBAR_INSERTCOLUMN")) {
            this.toolBar.add(insertColumnButton);
        }
        if (config.getBoolean("TOOLBAR_DELETEROW")) {
            this.toolBar.add(deleteRowButton);
        }
        if (config.getBoolean("TOOLBAR_DELETECOLUMN")) {
            this.toolBar.add(deleteColumnButton);
        }
        if (config.getBoolean("TOOLBAR_SORTCOLUMN")) {
            this.toolBar.add(sortButton);
        }
        this.toolBar.addSeparator();
        if (config.getBoolean("TOOLBAR_HISTOGRAM")) {
            this.toolBar.add(chartButton);
            this.toolBar.addSeparator();
        }
        if (config.getBoolean("TOOLBAR_HELP")) {
            this.toolBar.add(helpButton);
        }
        this.toolBar.addSeparator();
        this.toolBar.add(this.funcList);
        this.funcList.setVisible(config.getBoolean("TOOLBAR_FUNCTIONS"));
        this.newTableModel(config.getInt("ROWS"), config.getInt("COLUMNS"));
        int w = config.getInt("WIDTH");
        int h = config.getInt("HEIGHT");
        if (w >= 0 && h >= 0) {
            this.table.setPreferredScrollableViewportSize(new Dimension(w, h));
        }
        this.fileOp = new FileOp(this);
        this.table.setAutoResizeMode(0);
        this.table.setDefaultRenderer(Cell.class, new SharpCellRenderer());
        this.table.setDefaultEditor(Cell.class, new SharpCellEditor(new JTextField()));
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new HeaderMouseAdapter());
        this.rowSelectionModel = this.table.getSelectionModel();
        this.columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        this.rowSelectionModel.addListSelectionListener(this);
        this.columnSelectionModel.addListSelectionListener(this);
        this.setJMenuBar(this.menuBar);
        this.container.add((Component)this.toolBar, "North");
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.container.add((Component)this.scrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                SharpTools.this.table.requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                SharpTools.this.exit();
            }
        });
        this.resetSelection();
        this.table.setRequestFocusEnabled(true);
        this.menuBar.setRequestFocusEnabled(false);
        this.toolBar.setRequestFocusEnabled(false);
        this.table.requestFocus();
        this.pack();
        this.show();
    }

    public void setColumnWidth(int colWidth) {
        if (colWidth > 0) {
            for (int i = baseCol; i < this.tableModel.getColumnCount(); ++i) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setMinWidth(colWidth);
                column.setPreferredWidth(colWidth);
            }
        }
    }

    public void newTableModel(int rows, int cols) {
        this.tableModel = new SharpTableModel(this, rows, cols);
        this.table.setModel(this.tableModel);
        this.setBaseColumnWidth();
        this.setColumnWidth(config.getInt("COLUMNWIDTH"));
        this.history = new History(this);
        this.tableModel.setHistory(this.history);
        this.tableModel.setPasswordModified(false);
        this.tableModel.setModified(false);
        if (this.editOp == null) {
            this.editOp = new EditOp(this);
        } else {
            this.editOp.init(this);
        }
        this.tableOp = new TableOp(this);
        this.histogram = new Histogram(this, "Histograms", config.getInt("HISTOGRAMWIDTH"), config.getInt("HISTOGRAMHEIGHT"));
        this.tableModel.setModified(false);
        this.resetSelection();
        this.checkUndoRedoState();
        this.table.requestFocus();
    }

    public void noCellsSelected(String s) {
        SharpOptionPane.showMessageDialog(this, s + ": No cells selected", "Error", 0, null);
    }

    private void notYetImplemented() {
        SharpOptionPane.showMessageDialog(this, "Sorry, this function \nis not yet implemented!\nsharp@cs.columbia.edu", "Sharp Tools Spreadsheet", 2, null);
    }

    public void exit() {
        if (this.fileOp.closeFile()) {
            if (config.getBoolean("SAVEWINDOW")) {
                config.setInt("X", this.getX());
                config.setInt("Y", this.getY());
                Dimension dim = this.scrollPane.getViewport().getExtentSize();
                config.setInt("WIDTH", (int)dim.getWidth());
                config.setInt("HEIGHT", (int)dim.getHeight());
            }
            config.save();
            this.dispose();
        }
    }

    private void openInitFile(String filename) {
        this.fileOp.openTableModel(new File(filename));
    }

    public void checkSaveState() {
        boolean modified = this.tableModel.isModified();
        this.saveMenuItem.setEnabled(modified);
        this.saveButton.setEnabled(modified);
    }

    public void checkPasswordState() {
        if (this.fileOp.hasPassword()) {
            this.passwordButton.setIcon(this.lockedIcon);
        } else {
            this.passwordButton.setIcon(this.unlockedIcon);
        }
    }

    public void checkUndoRedoState() {
        boolean enable = this.history.isUndoable();
        this.undoMenuItem.setEnabled(enable);
        this.undoButton.setEnabled(enable);
        enable = this.history.isRedoable();
        this.redoMenuItem.setEnabled(enable);
        this.redoButton.setEnabled(enable);
    }

    public void checkFindNextState() {
        this.findNextMenuItem.setEnabled(this.editOp.hasFindValue());
    }

    public void checkShowHistogramState() {
        this.showHistogramMenuItem.setState(this.histogram.isVisible());
        this.showHistogramMenuItem.setEnabled(this.histogram.hasChart());
    }

    public void setBaseColumnWidth() {
        if (baseCol > 0) {
            TableColumn firstColumn = this.table.getColumnModel().getColumn(baseCol - 1);
            int firstColWidth = config.getInt("FIRSTCOLUMNWIDTH");
            if (firstColWidth > 0) {
                firstColumn.setMinWidth(firstColWidth);
                firstColumn.setPreferredWidth(firstColWidth);
            }
        }
    }

    public static void main(String[] args) {
        config = new Config("sharptools.ini");
        config.setInt("ROWS", 30);
        config.setInt("COLUMNS", 7);
        config.setInt("HISTOGRAMWIDTH", 600);
        config.setInt("HISTOGRAMHEIGHT", 400);
        config.setBoolean("TOOLBAR_NEW", true);
        config.setBoolean("TOOLBAR_OPEN", true);
        config.setBoolean("TOOLBAR_SAVE", true);
        config.setBoolean("TOOLBAR_PRINT", true);
        config.setBoolean("TOOLBAR_UNDO", true);
        config.setBoolean("TOOLBAR_REDO", true);
        config.setBoolean("TOOLBAR_CUT", true);
        config.setBoolean("TOOLBAR_COPY", true);
        config.setBoolean("TOOLBAR_PASTE", true);
        config.setBoolean("TOOLBAR_FIND", true);
        config.setBoolean("TOOLBAR_INSERTROW", true);
        config.setBoolean("TOOLBAR_INSERTCOLUMN", true);
        config.setBoolean("TOOLBAR_DELETEROW", true);
        config.setBoolean("TOOLBAR_DELETECOLUMN", true);
        config.setBoolean("TOOLBAR_FUNCTIONS", true);
        config.load();
        if (config.get("DEBUG") != null) {
            Debug.setDebug(config.getBoolean("DEBUG"));
        }
        Formula.registerFunctions();
        SharpTools spreadsheet = new SharpTools();
        spreadsheet.show();
        if (args.length > 0) {
            spreadsheet.openInitFile(args[0]);
        }
    }

    public static ImageIcon getImageIcon(String name) {
        URL url = ClassLoader.getSystemResource("sharptools/img/" + name);
        if (url == null) {
            System.out.println("image " + name + " not found");
            return null;
        }
        return new ImageIcon(url);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.table.requestFocus();
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty() && this.table.getColumnCount() > baseCol && this.table.getRowCount() > baseRow) {
            this.table.setRowSelectionInterval(baseRow, baseRow);
            this.table.setColumnSelectionInterval(baseCol, baseCol);
        }
    }

    public void resetSelection() {
        this.table.setRowSelectionInterval(baseRow, baseRow);
        this.table.setColumnSelectionInterval(baseCol, baseCol);
    }

    static {
        baseRow = 0;
        baseCol = 1;
    }

    class HeaderMouseAdapter
    extends MouseAdapter {
        HeaderMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableColumnModel colModel = SharpTools.this.table.getColumnModel();
            int col = colModel.getColumn(colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            int rowCount = SharpTools.this.table.getRowCount();
            SharpTools.this.table.setRowSelectionInterval(baseRow, rowCount - 1);
            if (col < baseCol) {
                SharpTools.this.table.setColumnSelectionInterval(baseCol, SharpTools.this.table.getColumnCount() - 1);
            } else {
                SharpTools.this.table.setColumnSelectionInterval(col, col);
            }
        }
    }
}

