/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import sharptools.Cell;

public class SharpCellEditor
extends DefaultCellEditor {
    private JTextField textField;

    public SharpCellEditor(final JTextField textField) {
        super(textField);
        this.textField = textField;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                if (value instanceof Cell) {
                    Cell temp = (Cell)value;
                    if (temp.isFormula()) {
                        textField.setText("=" + temp.getFormula().toString());
                    } else {
                        textField.setText(temp.getValue().toString());
                    }
                } else {
                    textField.setText(value == null ? "" : value.toString());
                }
            }

            @Override
            public Object getCellEditorValue() {
                return textField.getText();
            }
        };
        textField.addActionListener(this.delegate);
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

