/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPasswordField;
import sharptools.SharpDialog;
import sharptools.SharpOptionPane;
import sharptools.SharpTools;

public class PasswordDialog
extends SharpDialog {
    private JFrame frame;
    private String typedText = null;
    private String password;
    private final JPasswordField textField;
    private final JPasswordField confirmField;
    private static final ImageIcon passwordIcon = SharpTools.getImageIcon("password32.gif");

    public PasswordDialog(JFrame aFrame, String pass) {
        super(aFrame, "Password", true);
        this.frame = aFrame;
        this.password = pass;
        String msgString1 = "Enter password:";
        String msgString2 = "Confirm Password:";
        this.textField = new JPasswordField(10);
        this.confirmField = new JPasswordField(10);
        Object[] input = new Object[]{"Enter password:", this.textField, "Confirm Password:", this.confirmField};
        Object[] verify = new Object[]{"Enter password:", this.textField};
        Object[] array = this.password == null ? input : verify;
        this.setOptionPane(array, 3, 2, passwordIcon);
    }

    public String getValidatedText() {
        return this.typedText;
    }

    private static boolean fieldsAreTheSame(char[] input1, char[] input2) {
        if (input1.length != input2.length) {
            return false;
        }
        for (int i = 0; i < input1.length; ++i) {
            if (input1[i] == input2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean onOK() {
        this.typedText = new String(this.textField.getPassword());
        if (this.password != null) {
            if (!this.typedText.equals(this.password)) {
                SharpOptionPane.showMessageDialog(this, "Password Incorrect!", "Password", 0);
                this.textField.setText(null);
                this.textField.requestFocus();
                return false;
            }
            return true;
        }
        if (PasswordDialog.fieldsAreTheSame(this.textField.getPassword(), this.confirmField.getPassword())) {
            return true;
        }
        this.textField.selectAll();
        SharpOptionPane.showMessageDialog(this, "Passwords do not match!\nPlease try again.", "Password", 0, null);
        this.typedText = null;
        this.textField.setText(null);
        this.confirmField.setText(null);
        this.textField.requestFocus();
        return false;
    }

    @Override
    protected boolean onCancel() {
        this.typedText = null;
        return true;
    }

    @Override
    protected void onOpen() {
        this.textField.requestFocus();
    }
}

