/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.awt.Graphics;
import javax.swing.JPanel;

class HistoPanel
extends JPanel {
    private float[] bars;
    private float start;
    private float end;
    private float bucket;
    private float xmin;
    private float xmax;
    private float xunit;
    private float ymin;
    private float ymax;
    private float yunit;
    private float xscale;
    private float yscale;
    private int xsize;
    private int ysize;
    private int xborder = 50;
    private int yborder = 40;
    private boolean bypercentage;

    HistoPanel() {
    }

    public void setStartEndPoints(float start, float end, float bucket) {
        this.start = start;
        this.end = end;
        this.bucket = bucket;
    }

    public void setXYAxis(float xmin, float xmax, float xunit, float ymin, float ymax, float yunit) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.xunit = xunit;
        this.ymin = ymin;
        this.ymax = ymax;
        this.yunit = yunit;
        this.xscale = xmax - xmin;
        this.yscale = ymax - ymin;
        int len1 = String.valueOf(ymin).length();
        int len2 = String.valueOf(ymax).length();
        int len3 = String.valueOf(yunit).length();
        int maxdigits = Math.max(Math.max(len1, len2), len3);
        this.xborder = maxdigits * this.getGraphics().getFontMetrics().charWidth('0') + 10;
    }

    public void setByPercentage(boolean bypercentage) {
        this.bypercentage = bypercentage;
    }

    public void setData(float[] data) {
        this.bars = data;
    }

    public float[] getData() {
        return this.bars;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.bars == null) {
            return;
        }
        this.xsize = this.getXSize();
        this.ysize = this.getYSize();
        if (this.xsize < 0 || this.ysize < 0) {
            return;
        }
        float xratio = this.xscale / (float)this.xsize;
        float yratio = this.yscale / (float)this.ysize;
        this.drawLine(g, 0, 0, this.xsize + 20, 0);
        this.drawLine(g, 0, 0, 0, this.ysize + 20);
        if (this.bypercentage) {
            this.cString(g, "(%)", 0, this.ysize + 30);
        }
        for (float x = this.xmin; x <= this.xmax; x += this.xunit) {
            int xcoor = (int)((x - this.xmin) / xratio);
            this.drawLine(g, xcoor, 3, xcoor, -3);
            this.cString(g, String.valueOf(x), xcoor, -20);
        }
        for (float y = this.ymin; y <= this.ymax; y += this.yunit) {
            int ycoor = (int)((y - this.ymin) / yratio);
            this.drawLine(g, -3, ycoor, 3, ycoor);
            this.rString(g, String.valueOf(y), -5, ycoor);
        }
        for (int i = 0; i < this.bars.length; ++i) {
            float x = this.start + (float)(i - 1) * this.bucket;
            int ycoor = (int)((this.bars[i] - this.ymin) / yratio);
            int xcoor1 = (int)((x - this.xmin) / xratio);
            int xcoor2 = (int)((x + this.bucket - this.xmin) / xratio);
            xcoor1 = Math.max(xcoor1, 0);
            xcoor2 = Math.min(xcoor2, this.xsize);
            if (i == 0) {
                xcoor1 = 0;
            }
            if (i == this.bars.length - 1) {
                xcoor2 = this.xsize;
            }
            if (xcoor1 >= xcoor2) continue;
            this.drawLine(g, xcoor1, 0, xcoor1, ycoor);
            this.drawLine(g, xcoor2, 0, xcoor2, ycoor);
            this.drawLine(g, xcoor1, ycoor, xcoor2, ycoor);
        }
    }

    private int getXSize() {
        return this.getWidth() - 2 * this.xborder;
    }

    private int getYSize() {
        return this.getHeight() - 2 * this.yborder;
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1 + this.xborder, this.ysize - y1 + this.yborder, x2 + this.xborder, this.ysize - y2 + this.yborder);
    }

    private void drawString(Graphics g, String s, int x, int y) {
        g.drawString(s, x + this.xborder, this.ysize - y + this.yborder);
    }

    private int getx(int x) {
        return x + this.xborder;
    }

    private int gety(int y) {
        return this.ysize - y + this.yborder;
    }

    private void cString(Graphics g1, String s, int i, int j) {
        int k = g1.getFontMetrics().stringWidth(s);
        this.drawString(g1, s, i - k / 2, j);
    }

    private void rString(Graphics g1, String s, int i, int j) {
        int k = g1.getFontMetrics().stringWidth(s);
        this.drawString(g1, s, i - k, j);
    }
}

