/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import java.util.LinkedList;
import sharptools.CellPoint;
import sharptools.Function;
import sharptools.Node;
import sharptools.ParserException;
import sharptools.SharpTableModel;

class FunctionCount
extends Function {
    FunctionCount() {
    }

    @Override
    public Number evaluate(SharpTableModel table, Node node, int row, int col) throws ParserException {
        this.checkParamsExist(node);
        int count = 0;
        LinkedList params = node.getParams();
        if (params != null) {
            for (Node exp : params) {
                if (this.isRange(exp)) {
                    CellPoint[] addr = this.getFirst(exp).getAddressRange(row, col);
                    count += (addr[1].getRow() - addr[0].getRow() + 1) * (addr[1].getCol() - addr[0].getCol() + 1);
                    continue;
                }
                ++count;
            }
        }
        return new Integer(count);
    }

    @Override
    public String getUsage() {
        return "COUNT(value1,value2,...)";
    }

    @Override
    public String getDescription() {
        return "Counts the number of cells that contain numbers and numbers within the list of arguments.";
    }
}

