/*
 * Decompiled with CFR 0.152.
 */
package sharptools;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sharptools.CellPoint;
import sharptools.Formula;

public class AddressField
extends JTextField {
    public CellPoint getAddress() {
        return Formula.parseAddress(this.getText());
    }

    public void setAddress(CellPoint point) {
        if (point == null) {
            this.setText(null);
        } else {
            this.setText(point.toString());
        }
    }

    public AddressField(int columns) {
        super(columns);
        this.setDocument(new NumberFilterDocument());
    }

    class NumberFilterDocument
    extends PlainDocument {
        private StringBuffer __scratchBuffer = new StringBuffer();

        @Override
        public void insertString(int offset, String text, AttributeSet aset) throws BadLocationException {
            if (text == null || text.length() == 0) {
                return;
            }
            this.__scratchBuffer.setLength(0);
            try {
                this.__scratchBuffer.append(this.getText(0, this.getLength()));
                this.__scratchBuffer.insert(offset, text);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return;
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                sioobe.printStackTrace();
                return;
            }
            String buf = this.__scratchBuffer.toString();
            boolean hasNumber = false;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (!Character.isLetter(c)) {
                    if (Character.isDigit(c) && i > 0) {
                        hasNumber = true;
                        continue;
                    }
                    return;
                }
                if (!hasNumber) continue;
                return;
            }
            super.insertString(offset, text.toUpperCase(), aset);
        }
    }
}

