/*
 * Decompiled with CFR 0.152.
 */
package debuxter;

import debuxter.MainServices;
import debuxter.ScrollImWithRubber;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

class ScrollImScrollBar
extends Panel
implements AdjustmentListener {
    ScrollImWithRubber child;
    Scrollbar vAdjustable;
    Scrollbar hAdjustable;
    MainServices parent;
    static final long serialVersionUID = 20060308L;

    public ScrollImScrollBar(MainServices parent, Image theim, boolean onIndexedDisplay) {
        this.parent = parent;
        this.makeContents(theim, onIndexedDisplay);
        this.parent.notifyChangedSize();
    }

    protected void makeContents(Image theim, boolean onIndexedDisplay) {
        this.vAdjustable = new Scrollbar(1);
        this.hAdjustable = new Scrollbar(0);
        this.child = new ScrollImWithRubber(this, theim, onIndexedDisplay);
        this.setLayout(new BorderLayout());
        this.add("Center", this.child);
        this.add("South", this.hAdjustable);
        this.add("East", this.vAdjustable);
        this.hAdjustable.addAdjustmentListener(this);
        this.vAdjustable.addAdjustmentListener(this);
        this.doLayout();
        this.validate();
    }

    public void notifySelection(Rectangle bbox) {
        this.parent.notifySelection(bbox);
    }

    void resizeHoriz() {
        if (this.child == null || this.hAdjustable == null) {
            return;
        }
        int canvasWidth = this.child.getSize().width;
        int imWidth = this.child.getPreferredSize().width;
        this.child.setx0(0);
        this.hAdjustable.setValues(0, canvasWidth, 0, imWidth);
    }

    void resizeVert() {
        if (this.child == null || this.vAdjustable == null) {
            return;
        }
        int canvasHeight = this.child.getSize().height;
        int imHeight = this.child.getPreferredSize().height;
        this.child.sety0(0);
        this.vAdjustable.setValues(this.child.gety0(), canvasHeight, 0, imHeight);
    }

    @Override
    public void doLayout() {
        this.resizeHoriz();
        this.resizeVert();
        super.doLayout();
    }

    public void updateScrollbars() {
        this.hAdjustable.setValue(-this.child.getx0());
        this.vAdjustable.setValue(-this.child.gety0());
    }

    public void notifyChangedSize() {
        this.doLayout();
        this.parent.notifyChangedSize();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable() == this.vAdjustable) {
            this.child.sety0(e.getValue());
        } else if (e.getAdjustable() == this.hAdjustable) {
            this.child.setx0(e.getValue());
        }
    }
}

