/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.List;
import java.util.Map;

public abstract class mxGraphLayout
implements mxIGraphLayout {
    protected mxGraph graph;
    protected Object parent;
    protected boolean useBoundingBox = true;

    public mxGraphLayout(mxGraph graph) {
        this.graph = graph;
    }

    @Override
    public void execute(Object parent) {
        this.parent = parent;
    }

    @Override
    public void moveCell(Object cell, double x, double y) {
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public Object getConstraint(Object key, Object cell) {
        return this.getConstraint(key, cell, null, false);
    }

    public Object getConstraint(Object key, Object cell, Object edge, boolean source) {
        mxCellState state = this.graph.getView().getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.graph.getCellStyle(cell);
        return style != null ? style.get(key) : null;
    }

    public boolean isUseBoundingBox() {
        return this.useBoundingBox;
    }

    public void setUseBoundingBox(boolean useBoundingBox) {
        this.useBoundingBox = useBoundingBox;
    }

    public boolean isVertexMovable(Object vertex) {
        return this.graph.isCellMovable(vertex);
    }

    public boolean isVertexIgnored(Object vertex) {
        return !this.graph.getModel().isVertex(vertex) || !this.graph.isCellVisible(vertex);
    }

    public boolean isEdgeIgnored(Object edge) {
        mxIGraphModel model = this.graph.getModel();
        return !model.isEdge(edge) || !this.graph.isCellVisible(edge) || model.getTerminal(edge, true) == null || model.getTerminal(edge, false) == null;
    }

    public void setEdgeStyleEnabled(Object edge, boolean value) {
        this.graph.setCellStyles(mxConstants.STYLE_NOEDGESTYLE, value ? "0" : "1", new Object[]{edge});
    }

    public void setOrthogonalEdge(Object edge, boolean value) {
        this.graph.setCellStyles(mxConstants.STYLE_ORTHOGONAL, value ? "1" : "0", new Object[]{edge});
    }

    public mxPoint getParentOffset(Object parent) {
        mxIGraphModel model;
        mxPoint result = new mxPoint();
        if (parent != null && parent != this.parent && (model = this.graph.getModel()).isAncestor(this.parent, parent)) {
            mxGeometry parentGeo = model.getGeometry(parent);
            while (parent != this.parent) {
                result.setX(result.getX() + parentGeo.getX());
                result.setY(result.getY() + parentGeo.getY());
                parent = model.getParent(parent);
                parentGeo = model.getGeometry(parent);
            }
        }
        return result;
    }

    public void setEdgePoints(Object edge, List<mxPoint> points) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry geometry = model.getGeometry(edge);
        if (geometry == null) {
            geometry = new mxGeometry();
            geometry.setRelative(true);
        } else {
            geometry = (mxGeometry)geometry.clone();
        }
        if (this.parent != null && points != null) {
            Object parent = this.graph.getModel().getParent(edge);
            mxPoint parentOffset = this.getParentOffset(parent);
            for (mxPoint point : points) {
                point.setX(point.getX() - parentOffset.getX());
                point.setY(point.getY() - parentOffset.getY());
            }
        }
        geometry.setPoints(points);
        model.setGeometry(edge, geometry);
    }

    public mxRectangle getVertexBounds(Object vertex) {
        mxCellState state;
        mxRectangle geo = this.graph.getModel().getGeometry(vertex);
        if (this.useBoundingBox && (state = this.graph.getView().getState(vertex)) != null) {
            double scale = this.graph.getView().getScale();
            mxRectangle tmp = state.getBoundingBox();
            double dx0 = (tmp.getX() - state.getX()) / scale;
            double dy0 = (tmp.getY() - state.getY()) / scale;
            double dx1 = (tmp.getX() + tmp.getWidth() - state.getX() - state.getWidth()) / scale;
            double dy1 = (tmp.getY() + tmp.getHeight() - state.getY() - state.getHeight()) / scale;
            geo = new mxRectangle(geo.getX() + dx0, geo.getY() + dy0, geo.getWidth() - dx0 + dx1, geo.getHeight() + -dy0 + dy1);
        }
        if (this.parent != null) {
            Object parent = this.graph.getModel().getParent(vertex);
            geo = (mxRectangle)geo.clone();
            if (parent != null && parent != this.parent) {
                mxPoint parentOffset = this.getParentOffset(parent);
                geo.setX(geo.getX() + parentOffset.getX());
                geo.setY(geo.getY() + parentOffset.getY());
            }
        }
        return new mxRectangle(geo);
    }

    public mxRectangle setVertexLocation(Object vertex, double x, double y) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry geometry = model.getGeometry(vertex);
        mxRectangle result = null;
        if (geometry != null) {
            Object parent;
            mxCellState state;
            result = new mxRectangle(x, y, geometry.getWidth(), geometry.getHeight());
            mxGraphView graphView = this.graph.getView();
            if (this.useBoundingBox && (state = graphView.getState(vertex)) != null) {
                double scale = this.graph.getView().getScale();
                mxRectangle box = state.getBoundingBox();
                if (state.getBoundingBox().getX() < state.getX()) {
                    x += (state.getX() - box.getX()) / scale;
                    result.setWidth(box.getWidth());
                }
                if (state.getBoundingBox().getY() < state.getY()) {
                    y += (state.getY() - box.getY()) / scale;
                    result.setHeight(box.getHeight());
                }
            }
            if (this.parent != null && (parent = model.getParent(vertex)) != null && parent != this.parent) {
                mxPoint parentOffset = this.getParentOffset(parent);
                x -= parentOffset.getX();
                y -= parentOffset.getY();
            }
            if (geometry.getX() != x || geometry.getY() != y) {
                geometry = (mxGeometry)geometry.clone();
                geometry.setX(x);
                geometry.setY(y);
                model.setGeometry(vertex, geometry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arrangeGroups(Object[] groups, int border) {
        this.graph.getModel().beginUpdate();
        try {
            for (int i = groups.length - 1; i >= 0; --i) {
                Object group = groups[i];
                Object[] children = this.graph.getChildVertices(group);
                mxRectangle bounds = this.graph.getBoundingBoxFromGeometry(children);
                mxGeometry geometry = this.graph.getCellGeometry(group);
                double left = 0.0;
                double top = 0.0;
                if (this.graph.isSwimlane(group)) {
                    mxRectangle size = this.graph.getStartSize(group);
                    left = size.getWidth();
                    top = size.getHeight();
                }
                if (bounds == null || geometry == null) continue;
                geometry = (mxGeometry)geometry.clone();
                geometry.setX(geometry.getX() + bounds.getX() - (double)border - left);
                geometry.setY(geometry.getY() + bounds.getY() - (double)border - top);
                geometry.setWidth(bounds.getWidth() + (double)(2 * border) + left);
                geometry.setHeight(bounds.getHeight() + (double)(2 * border) + top);
                this.graph.getModel().setGeometry(group, geometry);
                this.graph.moveCells(children, (double)border + left - bounds.getX(), (double)border + top - bounds.getY());
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }
}

