/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.examples.swing;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxDomUtils;
import com.mxgraph.view.mxGraph;
import java.util.EventObject;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserObject
extends JFrame {
    private static final long serialVersionUID = -708317745824467773L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserObject() {
        super("Hello, World!");
        Document doc = mxDomUtils.createDocument();
        Element person1 = doc.createElement("Person");
        person1.setAttribute("firstName", "Daffy");
        person1.setAttribute("lastName", "Duck");
        Element person2 = doc.createElement("Person");
        person2.setAttribute("firstName", "Bugs");
        person2.setAttribute("lastName", "Bunny");
        Element relation = doc.createElement("Knows");
        relation.setAttribute("since", "1985");
        mxGraph graph = new mxGraph(){

            @Override
            public boolean isCellEditable(Object cell) {
                return !this.getModel().isEdge(cell);
            }

            @Override
            public String convertValueToString(Object cell) {
                Object value;
                if (cell instanceof mxCell && (value = ((mxCell)cell).getValue()) instanceof Element) {
                    Element elt = (Element)value;
                    if (elt.getTagName().equalsIgnoreCase("person")) {
                        String firstName = elt.getAttribute("firstName");
                        String lastName = elt.getAttribute("lastName");
                        if (lastName != null && lastName.length() > 0) {
                            return lastName + ", " + firstName;
                        }
                        return firstName;
                    }
                    if (elt.getTagName().equalsIgnoreCase("knows")) {
                        return elt.getTagName() + " (Since " + elt.getAttribute("since") + ")";
                    }
                }
                return super.convertValueToString(cell);
            }

            @Override
            public void cellLabelChanged(Object cell, Object newValue, boolean autoSize) {
                Object value;
                if (cell instanceof mxCell && newValue != null && (value = ((mxCell)cell).getValue()) instanceof Node) {
                    String label = newValue.toString();
                    Element elt = (Element)value;
                    if (elt.getTagName().equalsIgnoreCase("person")) {
                        int pos = label.indexOf(32);
                        String firstName = pos > 0 ? label.substring(0, pos).trim() : label;
                        String lastName = pos > 0 ? label.substring(pos + 1, label.length()).trim() : "";
                        elt = (Element)elt.cloneNode(true);
                        elt.setAttribute("firstName", firstName);
                        elt.setAttribute("lastName", lastName);
                        newValue = elt;
                    }
                }
                super.cellLabelChanged(cell, newValue, autoSize);
            }
        };
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        try {
            Object v1 = graph.insertVertex(parent, null, person1, 20.0, 20.0, 80.0, 30.0);
            Object v2 = graph.insertVertex(parent, null, person2, 240.0, 150.0, 80.0, 30.0);
            graph.insertEdge(parent, null, relation, v1, v2);
        }
        finally {
            graph.getModel().endUpdate();
        }
        mxGraphComponent graphComponent = new mxGraphComponent(graph){
            private static final long serialVersionUID = 6824440535661529806L;

            @Override
            public String getEditingValue(Object cell, EventObject trigger) {
                Element elt;
                Object value;
                if (cell instanceof mxCell && (value = ((mxCell)cell).getValue()) instanceof Element && (elt = (Element)value).getTagName().equalsIgnoreCase("person")) {
                    String firstName = elt.getAttribute("firstName");
                    String lastName = elt.getAttribute("lastName");
                    return firstName + " " + lastName;
                }
                return super.getEditingValue(cell, trigger);
            }
        };
        this.getContentPane().add(graphComponent);
        graphComponent.setEnterStopsCellEditing(true);
    }

    public static void main(String[] args) {
        UserObject frame = new UserObject();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 320);
        frame.setVisible(true);
    }
}

