/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import umontreal.iro.lecuyer.util.NameConflictException;

public class ClassFinder
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4847630831331065792L;
    private List<List<String>> imports = new LinkedList<List<String>>();

    public ClassFinder() {
        ArrayList imp = new ArrayList();
        this.imports.add(imp);
    }

    public List<String> getImports() {
        return this.imports.get(this.imports.size() - 1);
    }

    public void saveImports() {
        List<String> imp = this.getImports();
        ArrayList<String> impBack = new ArrayList<String>(imp);
        this.imports.add(impBack);
    }

    public void restoreImports() {
        if (this.imports.size() == 1) {
            this.getImports().clear();
        } else {
            this.imports.remove(this.imports.size() - 1);
        }
    }

    public Class<?> findClass(String name) throws ClassNotFoundException, NameConflictException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            List<String> imports = this.getImports();
            Class<?> candidate = null;
            String candidateImportString = "";
            boolean candidateImportOnDemand = false;
            int idxOut = name.indexOf(46);
            String outerName = idxOut == -1 ? name : name.substring(0, idxOut);
            for (String importString : imports) {
                Class<?> cl = null;
                boolean onDemand = false;
                if (!importString.endsWith(".*")) {
                    if (importString.endsWith("." + outerName)) {
                        String cn = importString.substring(0, importString.length() - outerName.length()) + name;
                        try {
                            cl = Class.forName(cn);
                        }
                        catch (ClassNotFoundException cnfe2) {}
                    }
                } else {
                    try {
                        cl = Class.forName(importString.substring(0, importString.length() - 1) + name);
                        onDemand = true;
                    }
                    catch (ClassNotFoundException cnfe3) {
                        // empty catch block
                    }
                }
                if (cl == null) continue;
                if (candidate == null || candidateImportOnDemand && !onDemand) {
                    candidate = cl;
                    candidateImportString = importString;
                    candidateImportOnDemand = onDemand;
                    continue;
                }
                if (candidate == cl) continue;
                throw new NameConflictException(this, name, "simple class name " + name + " matches " + candidate.getName() + " (import string " + candidateImportString + ") or " + cl.getName() + " (import string " + importString + ")");
            }
            if (candidate == null) {
                throw new ClassNotFoundException("Cannot find the class with name " + name);
            }
            return candidate;
        }
    }

    public String getSimpleName(Class<?> cls) {
        String pack;
        if (cls.isArray()) {
            return this.getSimpleName(cls.getComponentType()) + "[]";
        }
        if (cls.isPrimitive()) {
            return cls.getName();
        }
        Class<?> outer = cls;
        while (outer.getDeclaringClass() != null) {
            outer = outer.getDeclaringClass();
        }
        boolean needsFullyQualified = true;
        for (String importString : this.getImports()) {
            String pack2;
            if (importString.equals(outer.getName())) {
                needsFullyQualified = false;
                continue;
            }
            if (!importString.endsWith(".*") || !(pack2 = importString.substring(0, importString.length() - 2)).equals(cls.getPackage().getName())) continue;
            needsFullyQualified = false;
        }
        if (needsFullyQualified) {
            return cls.getName();
        }
        String name = cls.getName();
        if (!name.startsWith(pack = cls.getPackage().getName())) {
            throw new IllegalStateException("The class name " + name + " does not contain the package name " + pack);
        }
        return name.substring(pack.length() + 1);
    }

    public ClassFinder clone() {
        ClassFinder cf;
        try {
            cf = (ClassFinder)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new InternalError("CloneNotSupported thrown for a class implementing Cloneable");
        }
        cf.imports = new LinkedList<List<String>>();
        for (List<String> imp : this.imports) {
            ArrayList<String> impCpy = new ArrayList<String>(imp);
            cf.imports.add(impCpy);
        }
        return cf;
    }
}

