/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.StudentDist;
import umontreal.iro.lecuyer.randvar.StudentGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class StudentPolarGen
extends StudentGen {
    private boolean available = false;
    private double[] variates = new double[2];
    private static double[] staticVariates = new double[2];

    public StudentPolarGen(RandomStream s, int n) {
        super(s, null);
        this.setN(n);
    }

    public StudentPolarGen(RandomStream s, StudentDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setN(dist.getN());
        }
    }

    @Override
    public double nextDouble() {
        if (this.available) {
            this.available = false;
            return this.variates[1];
        }
        StudentPolarGen.polar(this.stream, this.n, this.variates);
        this.available = true;
        return this.variates[0];
    }

    public static double nextDouble(RandomStream s, int n) {
        StudentPolarGen.polar(s, n, staticVariates);
        return staticVariates[0];
    }

    private static void polar(RandomStream stream, int n, double[] variates) {
        double v;
        double u;
        double w;
        while ((w = (u = 2.0 * stream.nextDouble() - 1.0) * u + (v = 2.0 * stream.nextDouble() - 1.0) * v) > 1.0) {
        }
        double temp = Math.sqrt((double)n * (Math.exp(-2.0 / (double)n * Math.log(w)) - 1.0) / w);
        variates[0] = u * temp;
        variates[1] = v * temp;
    }
}

