/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.GeometricDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class GeometricGen
extends RandomVariateGenInt {
    private double p;

    public GeometricGen(RandomStream s, double p) {
        super(s, new GeometricDist(p));
        this.setParams(p);
    }

    public GeometricGen(RandomStream s, GeometricDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getP());
        }
    }

    @Override
    public int nextInt() {
        return GeometricDist.inverseF(this.p, this.stream.nextDouble());
    }

    public static int nextInt(RandomStream s, double p) {
        return GeometricDist.inverseF(p, s.nextDouble());
    }

    public double getP() {
        return this.p;
    }

    protected void setParams(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range [0, 1]");
        }
        this.p = p;
    }
}

