/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.randvar.ChiSquareNoncentralGen;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvar.NormalACRGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class ChiSquareNoncentralGamGen
extends ChiSquareNoncentralGen {
    private double racLam = -1.0;

    public ChiSquareNoncentralGamGen(RandomStream stream, double nu, double lambda) {
        super(stream, null);
        this.setParams(nu, lambda);
        this.racLam = Math.sqrt(lambda);
    }

    @Override
    public double nextDouble() {
        return ChiSquareNoncentralGamGen.gamGen(this.stream, this.nu, this.racLam);
    }

    public static double nextDouble(RandomStream stream, double nu, double lambda) {
        double racLam = Math.sqrt(lambda);
        return ChiSquareNoncentralGamGen.gamGen(stream, nu, racLam);
    }

    private static double gamGen(RandomStream s, double nu, double racLam) {
        double x = NormalACRGen.nextDouble(s, racLam, 1.0);
        double y = GammaAcceptanceRejectionGen.nextDouble(s, 0.5 * (nu - 1.0), 0.5);
        return x * x + y;
    }
}

