/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.RootFinder;

public class WatsonUDist
extends ContinuousDistribution {
    private static final double XSEPARE = 0.15;
    private static final double PI = Math.PI;
    private static final int JMAX = 10;
    protected int n;

    private static double cdfn(int n, double x) {
        double a;
        double der;
        double terme;
        double v = Math.exp(-0.125 / x);
        double somme = 0.0;
        int j = 0;
        do {
            a = (2 * j + 1) * (2 * j + 1);
            terme = Math.pow(v, (double)(2 * j + 1) * (double)(2 * j + 1));
            der = terme * (a - 4.0 * x) / (8.0 * x * x);
            somme += (5.0 * x - 0.08333333333333333) * der / 12.0;
        } while (!(terme <= Math.abs(somme += x * x * (der = terme * (a * a - 24.0 * a * x + 48.0 * x * x) / (64.0 * x * x * x * x)) / 6.0) * 2.220446049250313E-16) && ++j <= 10);
        if (j > 10) {
            System.err.println(x + ": watsonU:  somme 1/n has not converged");
        }
        v = -2.0 * somme / ((double)n * Math.sqrt(Math.PI * 2 * x));
        return v;
    }

    public WatsonUDist(int n) {
        this.setN(n);
    }

    @Override
    public double density(double x) {
        return WatsonUDist.density(this.n, x);
    }

    @Override
    public double cdf(double x) {
        return WatsonUDist.cdf(this.n, x);
    }

    @Override
    public double barF(double x) {
        return WatsonUDist.barF(this.n, x);
    }

    @Override
    public double inverseF(double u) {
        return WatsonUDist.inverseF(this.n, u);
    }

    @Override
    public double getMean() {
        return WatsonUDist.getMean(this.n);
    }

    @Override
    public double getVariance() {
        return WatsonUDist.getVariance(this.n);
    }

    @Override
    public double getStandardDeviation() {
        return WatsonUDist.getStandardDeviation(this.n);
    }

    public static double density(int n, double x) {
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        if (x <= 1.0 / (12.0 * (double)n) || x >= (double)n / 12.0 || x >= 100.0) {
            return 0.0;
        }
        double EPS = 0.01;
        return (WatsonUDist.cdf(n, x + 0.01) - WatsonUDist.cdf(n, x - 0.01)) / 0.02;
    }

    public static double cdf(int n, double x) {
        double terme;
        double v;
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        if (x <= 1.0 / (12.0 * (double)n)) {
            return 0.0;
        }
        if (x > 3.95 || x >= (double)n / 12.0) {
            return 1.0;
        }
        if (2 == n) {
            if (x <= 0.041666666666666664) {
                return 0.0;
            }
            if (x >= 0.16666666666666666) {
                return 1.0;
            }
            return 2.0 * Math.sqrt(2.0 * x - 0.08333333333333333);
        }
        if (x > 0.15) {
            return 1.0 - WatsonUDist.barF(n, x);
        }
        double somme = v = Math.exp(-0.125 / x);
        int j = 2;
        while (!((terme = Math.pow(v, (double)(2 * j - 1) * (double)(2 * j - 1))) <= (somme += terme) * 2.220446049250313E-16) && ++j <= 10) {
        }
        if (j > 10) {
            System.err.println(x + ": watsonU:  sum2 has not converged");
        }
        v = 2.0 * somme / Math.sqrt(Math.PI * 2 * x);
        if ((v += WatsonUDist.cdfn(n, x)) >= 1.0) {
            return 1.0;
        }
        if (v <= 0.0) {
            return 0.0;
        }
        return v;
    }

    public static double barF(int n, double x) {
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        if (x <= 1.0 / (12.0 * (double)n)) {
            return 1.0;
        }
        if (x >= 100.0 || x >= (double)n / 12.0) {
            return 0.0;
        }
        if (2 == n) {
            return 1.0 - 2.0 * Math.sqrt(2.0 * x - 0.08333333333333333);
        }
        if (x > 0.15) {
            double terme;
            double v = Math.exp(-19.739208802178716 * x);
            double signe = 1.0;
            double somme = 0.0;
            double son = 0.0;
            int j = 1;
            do {
                terme = Math.pow(v, (double)j * (double)j);
                somme += signe * terme;
                double h = (double)(2 * j) * Math.PI * x;
                double ter = (5.0 * x - h * h - 0.08333333333333333) * (double)j * (double)j;
                son += signe * terme * ter;
                signe = -signe;
            } while (!(terme < 2.220446049250313E-16) && ++j <= 10);
            if (j > 10) {
                System.err.println(x + ": watsonU:  sum1 has not converged");
            }
            if ((v = 2.0 * somme + Math.PI * Math.PI * son / (3.0 * (double)n)) <= 0.0) {
                return 0.0;
            }
            if (v >= 1.0) {
                return 1.0;
            }
            return v;
        }
        return 1.0 - WatsonUDist.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u >= 1.0) {
            return (double)n / 12.0;
        }
        if (u <= 0.0) {
            return 1.0 / (12.0 * (double)n);
        }
        if (2 == n) {
            return 0.041666666666666664 + u * u / 8.0;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 2.0, f, 1.0E-7);
    }

    public static double getMean(int n) {
        return 0.08333333333333333;
    }

    public static double getVariance(int n) {
        return (double)(n - 1) / (360.0 * (double)n);
    }

    public static double getStandardDeviation(int n) {
        return Math.sqrt(WatsonUDist.getVariance(n));
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        this.n = n;
        this.supportA = 1.0 / (12.0 * (double)n);
        this.supportB = (double)n / 12.0;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        @Override
        public double evaluate(double x) {
            return this.u - WatsonUDist.cdf(this.n, x);
        }
    }
}

