/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.RootFinder;

public class KolmogorovSmirnovDist
extends ContinuousDistribution {
    protected int n;
    protected static final int NLIM = 20;
    private static final double NORM = 1.0E140;
    private static final double INORM = 1.0E-140;
    private static final int LOGNORM = 140;

    public KolmogorovSmirnovDist(int n) {
        this.setN(n);
    }

    @Override
    public double density(double x) {
        return KolmogorovSmirnovDist.density(this.n, x);
    }

    @Override
    public double cdf(double x) {
        return KolmogorovSmirnovDist.cdf(this.n, x);
    }

    @Override
    public double barF(double x) {
        return KolmogorovSmirnovDist.barF(this.n, x);
    }

    @Override
    public double inverseF(double u) {
        return KolmogorovSmirnovDist.inverseF(this.n, u);
    }

    private static double dclem(int n, double x, double EPS) {
        return (KolmogorovSmirnovDist.cdf(n, x + EPS) - KolmogorovSmirnovDist.cdf(n, x - EPS)) / (2.0 * EPS);
    }

    protected static double densConnue(int n, double x) {
        if (x >= 1.0 || x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0;
        }
        if (x <= 1.0 / (double)n) {
            double t = 2.0 * x - 1.0 / (double)n;
            if (n <= 20) {
                double w = 2.0 * (double)n * Num.factorial(n);
                return w *= Math.pow(t, n - 1);
            }
            double w = Num.lnFactorial(n) + (double)(n - 1) * Math.log(t);
            return (double)(2 * n) * Math.exp(w);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 2.0 * (double)n * Math.pow(1.0 - x, n - 1);
        }
        return -1.0;
    }

    public static double density(int n, double x) {
        double D2;
        double Res = KolmogorovSmirnovDist.densConnue(n, x);
        if (Res != -1.0) {
            return Res;
        }
        double EPS = 0.005;
        double D1 = KolmogorovSmirnovDist.dclem(n, x, EPS);
        Res = D1 + (D1 - (D2 = KolmogorovSmirnovDist.dclem(n, x, 2.0 * EPS))) / 3.0;
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    private static void mMultiply(double[] A, double[] B, double[] C, int m) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < m; ++j) {
                double s = 0.0;
                for (int k = 0; k < m; ++k) {
                    s += A[i * m + k] * B[k * m + j];
                }
                C[i * m + j] = s;
            }
        }
    }

    private static void renormalize(double[] V, int m, int[] p) {
        int i = 0;
        while (i < m * m) {
            int n = i++;
            V[n] = V[n] * 1.0E-140;
        }
        p[0] = p[0] + 140;
    }

    private static void mPower(double[] A, int eA, double[] V, int[] eV, int m, int n) {
        if (n == 1) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = A[i];
            }
            eV[0] = eA;
            return;
        }
        KolmogorovSmirnovDist.mPower(A, eA, V, eV, m, n / 2);
        double[] B = new double[m * m];
        int[] pB = new int[1];
        KolmogorovSmirnovDist.mMultiply(V, V, B, m);
        pB[0] = 2 * eV[0];
        if (B[m / 2 * m + m / 2] > 1.0E140) {
            KolmogorovSmirnovDist.renormalize(B, m, pB);
        }
        if (n % 2 == 0) {
            for (int i = 0; i < m * m; ++i) {
                V[i] = B[i];
            }
            eV[0] = pB[0];
        } else {
            KolmogorovSmirnovDist.mMultiply(A, B, V, m);
            eV[0] = eA + pB[0];
        }
        if (V[m / 2 * m + m / 2] > 1.0E140) {
            KolmogorovSmirnovDist.renormalize(V, m, eV);
        }
    }

    protected static double DurbinMatrix(int n, double d) {
        int j;
        int i;
        int k = (int)((double)n * d) + 1;
        int m = 2 * k - 1;
        double h = (double)k - (double)n * d;
        double[] H = new double[m * m];
        double[] Q = new double[m * m];
        int[] pQ = new int[1];
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                H[i * m + j] = i - j + 1 < 0 ? 0.0 : 1.0;
            }
        }
        for (i = 0; i < m; ++i) {
            int n2 = i * m;
            H[n2] = H[n2] - Math.pow(h, i + 1);
            int n3 = (m - 1) * m + i;
            H[n3] = H[n3] - Math.pow(h, m - i);
        }
        int n4 = (m - 1) * m;
        H[n4] = H[n4] + (2.0 * h - 1.0 > 0.0 ? Math.pow(2.0 * h - 1.0, m) : 0.0);
        for (i = 0; i < m; ++i) {
            for (j = 0; j < m; ++j) {
                if (i - j + 1 <= 0) continue;
                for (int g = 1; g <= i - j + 1; ++g) {
                    int n5 = i * m + j;
                    H[n5] = H[n5] / (double)g;
                }
            }
        }
        int eH = 0;
        KolmogorovSmirnovDist.mPower(H, eH, Q, pQ, m, n);
        double s = Q[(k - 1) * m + k - 1];
        for (i = 1; i <= n; ++i) {
            if (!((s = s * (double)i / (double)n) < 1.0E-140)) continue;
            s *= 1.0E140;
            pQ[0] = pQ[0] - 140;
        }
        return s *= Math.pow(10.0, pQ[0]);
    }

    protected static double cdfConnu(int n, double x) {
        if ((double)n * x * x >= 18.0 || x >= 1.0) {
            return 1.0;
        }
        if (x <= 0.5 / (double)n) {
            return 0.0;
        }
        if (n == 1) {
            return 2.0 * x - 1.0;
        }
        if (x <= 1.0 / (double)n) {
            double t = 2.0 * x - 1.0 / (double)n;
            if (n <= 20) {
                double w = Num.factorial(n);
                return w * Math.pow(t, n);
            }
            double w = Num.lnFactorial(n) + (double)n * Math.log(t);
            return Math.exp(w);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 1.0 - 2.0 * Math.pow(1.0 - x, n);
        }
        return -1.0;
    }

    public static double cdf(int n, double x) {
        double Res = KolmogorovSmirnovDist.cdfConnu(n, x);
        if (Res != -1.0) {
            return Res;
        }
        return KolmogorovSmirnovDist.DurbinMatrix(n, x);
    }

    protected static double barFConnu(int n, double x) {
        if ((double)n * x * x >= 370.0 || x >= 1.0) {
            return 0.0;
        }
        if ((double)n * x * x <= 0.0274 || x <= 0.5 / (double)n) {
            return 1.0;
        }
        if (n == 1) {
            return 2.0 - 2.0 * x;
        }
        if (x <= 1.0 / (double)n) {
            double t = 2.0 * x - 1.0 / (double)n;
            if (n <= 20) {
                double w = Num.factorial(n);
                return 1.0 - w * Math.pow(t, n);
            }
            double w = Num.lnFactorial(n) + (double)n * Math.log(t);
            return 1.0 - Math.exp(w);
        }
        if (x >= 1.0 - 1.0 / (double)n) {
            return 2.0 * Math.pow(1.0 - x, n);
        }
        return -1.0;
    }

    public static double barF(int n, double x) {
        double h = KolmogorovSmirnovDist.barFConnu(n, x);
        if (h >= 0.0) {
            return h;
        }
        h = 1.0 - KolmogorovSmirnovDist.cdf(n, x);
        if (h >= 0.0) {
            return h;
        }
        return 0.0;
    }

    protected static double inverseConnue(int n, double u) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return 1.0;
        }
        if (u == 0.0) {
            return 0.5 / (double)n;
        }
        if (n == 1) {
            return (u + 1.0) / 2.0;
        }
        double NLNN = (double)n * Math.log(n);
        double LNU = Math.log(u) - Num.lnFactorial(n);
        if (LNU <= -NLNN) {
            double t = 1.0 / (double)n * LNU;
            return 0.5 * (Math.exp(t) + 1.0 / (double)n);
        }
        if (u >= 1.0 - 2.0 / Math.exp(NLNN)) {
            return 1.0 - Math.pow((1.0 - u) / 2.0, 1.0 / (double)n);
        }
        return -1.0;
    }

    public static double inverseF(int n, double u) {
        double Res = KolmogorovSmirnovDist.inverseConnue(n, u);
        if (Res != -1.0) {
            return Res;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.5 / (double)n, 1.0, f, 1.0E-10);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.n = n;
        this.supportA = 0.5 / (double)n;
        this.supportB = 1.0;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.n;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        @Override
        public double evaluate(double x) {
            return this.u - KolmogorovSmirnovDist.cdf(this.n, x);
        }
    }
}

