/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class ContinuousDistribution
implements Distribution {
    @Deprecated
    public int decPrec = 15;
    protected static final double XBIG = 100.0;
    protected static final double XBIGM = 1000.0;
    protected double supportA = Double.NEGATIVE_INFINITY;
    protected double supportB = Double.POSITIVE_INFINITY;
    protected static final double[] EPSARRAY = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18, 5.0E-19, 5.0E-20, 5.0E-21, 5.0E-22, 5.0E-23, 5.0E-24, 5.0E-25, 5.0E-26, 5.0E-27, 5.0E-28, 5.0E-29, 5.0E-30, 5.0E-31, 5.0E-32, 5.0E-33, 5.0E-34, 5.0E-35, 5.0E-36};

    private int getDecPrec() {
        return this.decPrec;
    }

    public abstract double density(double var1);

    @Override
    public double barF(double x) {
        return 1.0 - this.cdf(x);
    }

    private void findInterval(double u, double[] iv) {
        double a;
        double b;
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        double XLIM = 8.988465674311579E307;
        double B0 = 8.0;
        for (b = 8.0; b < 8.988465674311579E307 && u > this.cdf(b); b *= 2.0) {
        }
        if (b > 8.0) {
            iv[0] = b / 2.0;
            iv[1] = Math.min(b, this.supportB);
            return;
        }
        for (a = -8.0; a > -8.988465674311579E307 && u < this.cdf(a); a *= 2.0) {
        }
        if (a < -8.0) {
            iv[1] = a / 2.0;
            iv[0] = Math.max(a, this.supportA);
            return;
        }
        iv[0] = Math.max(a, this.supportA);
        iv[1] = Math.min(b, this.supportB);
    }

    public double inverseBrent(double a, double b, double u, double tol) {
        int i;
        double len;
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (b < a) {
            double ctemp = a;
            a = b;
            b = ctemp;
        }
        if (u <= 0.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 0");
            return this.supportA;
        }
        if (u >= 1.0) {
            System.out.println("********** WARNING,  inverseBrent:   u = 1");
            return this.supportB;
        }
        int MAXITER = 50;
        tol += EPSARRAY[this.decPrec] + 2.220446049250313E-16;
        double ua = this.cdf(a) - u;
        if (ua > 0.0) {
            throw new IllegalArgumentException("u < cdf(a)");
        }
        double ub = this.cdf(b) - u;
        if (ub < 0.0) {
            throw new IllegalArgumentException("u > cdf(b)");
        }
        boolean DEBUG = false;
        double c = a;
        double uc = ua;
        double t = len = b - a;
        if (Math.abs(uc) < Math.abs(ub)) {
            a = b;
            b = c;
            c = a;
            ua = ub;
            ub = uc;
            uc = ua;
        }
        for (i = 0; i < 50; ++i) {
            double tol1 = tol + 8.881784197001252E-16 * Math.abs(b);
            double xm = 0.5 * (c - b);
            if (Math.abs(ub) == 0.0 || Math.abs(xm) <= tol1) {
                if (b <= this.supportA) {
                    return this.supportA;
                }
                if (b >= this.supportB) {
                    return this.supportB;
                }
                return b;
            }
            if (Math.abs(t) >= tol1 && Math.abs(ua) > Math.abs(ub)) {
                double p;
                double q;
                double s;
                if (a == c) {
                    s = ub / ua;
                    q = 1.0 - s;
                    p = 2.0 * xm * s;
                } else {
                    q = ua / uc;
                    double r = ub / uc;
                    s = ub / ua;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) >= 3.0 * xm * q - Math.abs(q * tol1) || p >= Math.abs(0.5 * t * q)) {
                    t = len = xm;
                } else {
                    t = len;
                    len = p / q;
                }
            } else {
                t = len = xm;
            }
            a = b;
            ua = ub;
            b = Math.abs(len) > tol1 ? (b += len) : (xm < 0.0 ? (b -= tol1) : (b += tol1));
            ub = this.cdf(b) - u;
            if (ub * (uc / Math.abs(uc)) > 0.0) {
                c = a;
                uc = ua;
                t = len = b - a;
                continue;
            }
            if (!(Math.abs(uc) < Math.abs(ub))) continue;
            a = b;
            b = c;
            c = a;
            ua = ub;
            ub = uc;
            uc = ua;
        }
        if (i >= 50) {
            String lineSep = System.getProperty("line.separator");
            System.out.println(lineSep + "*********** inverseBrent:   no convergence after " + 50 + " iterations");
        }
        return b;
    }

    public double inverseBisection(double u) {
        int MAXITER = 100;
        double EPSILON = EPSARRAY[this.decPrec];
        double XLIM = 8.988465674311579E307;
        boolean DEBUG = false;
        String lineSep = System.getProperty("line.separator");
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (this.decPrec > 15) {
            throw new IllegalArgumentException("decPrec too large");
        }
        if (this.decPrec <= 0) {
            throw new IllegalArgumentException("decPrec <= 0");
        }
        double x = 0.0;
        if (u <= 0.0) {
            x = this.supportA;
            return x;
        }
        if (u >= 1.0) {
            x = this.supportB;
            return x;
        }
        double[] iv = new double[2];
        this.findInterval(u, iv);
        double xa = iv[0];
        double xb = iv[1];
        double yb = this.cdf(xb) - u;
        double ya = this.cdf(xa) - u;
        boolean fini = false;
        int i = 0;
        while (!fini) {
            x = (xa + xb) / 2.0;
            double y = this.cdf(x) - u;
            if (y == 0.0 || Math.abs((xb - xa) / (x + 2.220446049250313E-16)) <= EPSILON) {
                fini = true;
            } else if (y * ya < 0.0) {
                xb = x;
            } else {
                xa = x;
            }
            if (++i <= 100) continue;
            fini = true;
        }
        return x;
    }

    @Override
    public double inverseF(double u) {
        double[] iv = new double[2];
        this.findInterval(u, iv);
        return this.inverseBrent(iv[0], iv[1], u, EPSARRAY[this.decPrec]);
    }

    @Override
    public double getMean() {
        throw new UnsupportedOperationException("getMean is not implemented ");
    }

    @Override
    public double getVariance() {
        throw new UnsupportedOperationException("getVariance is not implemented ");
    }

    @Override
    public double getStandardDeviation() {
        throw new UnsupportedOperationException("getStandardDeviation is not implemented ");
    }

    public double getXinf() {
        return this.supportA;
    }

    public double getXsup() {
        return this.supportB;
    }

    public void setXinf(double xa) {
        this.supportA = xa;
    }

    public void setXsup(double xb) {
        this.supportB = xb;
    }
}

