/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class F2wStructure {
    private final int ALLONES = Integer.MAX_VALUE;
    int w;
    int r;
    int numBits;
    private int modQ;
    private int step;
    private int[] coeff;
    private int[] nocoeff;
    private int nbcoeff;
    int S;
    private int maskw;
    private int maskrw;
    private int maskZrm1;
    private int mask31;
    private int t;
    private int masktrw;
    private int[] maskv;
    int state;
    int output;
    double normFactor;
    double EpsilonHalf;
    static final int MBL = 140;

    private void init(int w, int r, int modQ, int step, int nbcoeff, int[] coeff, int[] nocoeff) {
        this.normFactor = 4.656612873077393E-10;
        this.EpsilonHalf = 0.5 * this.normFactor;
        this.numBits = 31;
        this.step = step;
        this.w = w;
        this.r = r;
        this.S = 31 - r * w;
        this.mask31 = Integer.MAX_VALUE;
        this.maskw = (1 << w) - 1;
        this.maskrw = (1 << r * w) - 1 << this.S;
        this.maskZrm1 = Integer.MAX_VALUE >> r * w ^ Integer.MAX_VALUE >> (r - 1) * w;
        this.modQ = modQ;
        this.nbcoeff = nbcoeff;
        this.nocoeff = new int[nbcoeff];
        this.coeff = new int[nbcoeff];
        for (int j = 0; j < nbcoeff; ++j) {
            this.nocoeff[j] = nocoeff[j];
            this.coeff[j] = coeff[j];
        }
    }

    void initParamLFSR() {
        this.t = (31 - this.r * this.w) / this.w;
        this.masktrw = -1 << 31 - (this.t + this.r) * this.w & this.mask31;
        this.maskv = new int[this.r];
        for (int j = 0; j < this.r; ++j) {
            this.maskv[j] = this.maskw << this.S + (this.r - 1 - j) * this.w;
        }
    }

    F2wStructure(int w, int r, int modQ, int step, int nbcoeff, int[] coeff, int[] nocoeff) {
        this.init(w, r, modQ, step, nbcoeff, coeff, nocoeff);
    }

    F2wStructure(String filename, int no) {
        try {
            BufferedReader input;
            if (new File(filename).exists()) {
                input = new BufferedReader(new FileReader(filename));
            } else {
                DataInputStream dataInput = new DataInputStream(F2wStructure.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataF2w/" + filename));
                input = new BufferedReader(new InputStreamReader(dataInput));
            }
            this.initFromReader(filename, input, no);
            input.close();
        }
        catch (Exception e) {
            System.out.println("IO Error: problems finding file " + filename);
            System.exit(1);
        }
    }

    private int multiplyz(int a, int k) {
        if (k == 0) {
            return a & this.maskw;
        }
        for (int i = 0; i < k; ++i) {
            if ((1 & a) == 1) {
                a = a >> 1 ^ this.modQ;
                continue;
            }
            a >>= 1;
        }
        return a & this.maskw;
    }

    int getLog2N() {
        return this.r * this.w;
    }

    int multiply(int a, int b) {
        int res = 0;
        int verif = 1;
        for (int i = 0; i < this.w; ++i) {
            if ((b & verif) == verif) {
                res ^= this.multiplyz(a, this.w - 1 - i);
            }
            verif <<= 1;
        }
        return res & this.maskw;
    }

    void initF2wLFSR() {
        int tempState;
        int d = 0;
        this.output = tempState = this.state << this.S;
        for (int i = 1; i <= this.t; ++i) {
            d = 0;
            for (int j = 0; j < this.nbcoeff; ++j) {
                int v = (tempState & this.maskv[this.nocoeff[j]]) >> this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
                d ^= this.multiply(this.coeff[j], v);
            }
            this.output |= d << this.S - i * this.w;
            tempState = this.output << i * this.w & this.maskrw;
        }
    }

    void F2wLFSR() {
        int d = 0;
        for (int i = 0; i < this.step; ++i) {
            int tempState = this.output << this.t * this.w & this.maskrw;
            d = 0;
            for (int j = 0; j < this.nbcoeff; ++j) {
                int v = (tempState & this.maskv[this.nocoeff[j]]) >> this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
                d ^= this.multiply(this.coeff[j], v);
            }
            this.output = this.output << this.w & this.masktrw | d << 31 - (this.r + this.t) * this.w;
        }
        this.state = (this.output & this.maskrw) >> this.S;
    }

    int F2wPolyLCG() {
        for (int i = 0; i < this.step; ++i) {
            int Zrm1 = (this.state & this.maskZrm1) >> this.S;
            this.state = this.state >> this.w & this.maskrw;
            for (int j = 0; j < this.nbcoeff; ++j) {
                this.state ^= this.multiply(this.coeff[j], Zrm1) << this.S + (this.r - 1 - this.nocoeff[j]) * this.w;
            }
        }
        return this.state;
    }

    public static void print(String filename) {
        try {
            String s;
            BufferedReader input;
            if (new File(filename).exists()) {
                input = new BufferedReader(new FileReader(filename));
            } else {
                DataInputStream dataInput = new DataInputStream(F2wStructure.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/hups/dataF2w/" + filename));
                input = new BufferedReader(new InputStreamReader(dataInput));
            }
            for (int i = 0; i < 4; ++i) {
                input.readLine();
            }
            while ((s = input.readLine()) != null) {
                System.out.println(s);
            }
            input.close();
        }
        catch (Exception e) {
            System.out.println("IO Error: problems reading file " + filename);
            System.exit(1);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("z^");
        sb.append(this.r);
        for (int j = this.nbcoeff - 1; j >= 0; --j) {
            sb.append(" + (" + this.coeff[j] + ") z^" + this.nocoeff[j]);
        }
        sb.append("   modQ = " + this.modQ + "    w = " + this.w + "   step = " + this.step);
        return sb.toString();
    }

    private void initFromReader(String filename, BufferedReader input, int no) {
        int nl = no + 4;
        try {
            for (int j = 1; j < nl; ++j) {
                input.readLine();
            }
            StringTokenizer line = new StringTokenizer(input.readLine());
            int w = Integer.parseInt(line.nextToken());
            int r = Integer.parseInt(line.nextToken());
            int modQ = Integer.parseInt(line.nextToken());
            int step = Integer.parseInt(line.nextToken());
            int nbcoeff = Integer.parseInt(line.nextToken());
            int[] nocoeff = new int[nbcoeff];
            int[] coeff = new int[nbcoeff];
            for (int i = 0; i < nbcoeff; ++i) {
                coeff[i] = Integer.parseInt(line.nextToken());
                nocoeff[i] = Integer.parseInt(line.nextToken());
            }
            this.init(w, r, modQ, step, nbcoeff, coeff, nocoeff);
            input.close();
        }
        catch (Exception e) {
            System.out.println("Input Error: problems reading file " + filename);
            System.exit(1);
        }
    }
}

