/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import cern.colt.list.DoubleArrayList;
import java.io.PrintWriter;
import umontreal.iro.lecuyer.gof.FDist;
import umontreal.iro.lecuyer.gof.GofStat;
import umontreal.iro.lecuyer.probdist.AndersonDarlingDistQuick;
import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.CramerVonMisesDist;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovDistQuick;
import umontreal.iro.lecuyer.probdist.KolmogorovSmirnovPlusDist;
import umontreal.iro.lecuyer.probdist.WatsonGDist;
import umontreal.iro.lecuyer.probdist.WatsonUDist;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class GofFormat {
    public static final int GNUPLOT = 0;
    public static final int MATHEMATICA = 1;
    public static int graphSoft = 0;
    public static double EPSILONP = 1.0E-15;
    public static double SUSPECTP = 0.01;
    public static final int KSP = 0;
    public static final int KSM = 1;
    public static final int KS = 2;
    public static final int AD = 3;
    public static final int CM = 4;
    public static final int WG = 5;
    public static final int WU = 6;
    public static final int MEAN = 7;
    public static final int COR = 8;
    public static final int NTESTTYPES = 9;
    public static final String[] TESTNAMES = new String[]{"KolmogorovSmirnovPlus", "KolmogorovSmirnovMinus", "KolmogorovSmirnov", "Anderson-Darling", "CramerVon-Mises", "Watson G", "Watson U", "Mean", "Correlation"};
    public static boolean[] activeTests = null;

    private GofFormat() {
    }

    private static String formatMath2(double x, double y) {
        int exppos;
        String S;
        StringBuffer sb = new StringBuffer();
        sb.append("   { ");
        if (x != 0.0 && (x < 0.1 || x > 1.0)) {
            S = PrintfFormat.E(16, 7, x);
            exppos = S.indexOf(69);
            if (exppos != -1) {
                S = S.substring(0, exppos) + "*10^(" + S.substring(exppos + 1) + ")";
            }
        } else {
            S = PrintfFormat.g(16, 8, x);
        }
        sb.append(S + ",     ");
        if (y != 0.0 && (y < 0.1 || y > 1.0)) {
            S = PrintfFormat.E(16, 7, y);
            exppos = S.indexOf(69);
            if (exppos != -1) {
                S = S.substring(0, exppos) + "*10^(" + S.substring(exppos + 1) + ")";
            }
        } else {
            S = PrintfFormat.g(16, 8, y);
        }
        sb.append(S + " }");
        return sb.toString();
    }

    private static String graphFunc(ContinuousDistribution dist, double a, double b, int m, int mono, String desc) {
        StringBuffer sb = new StringBuffer();
        String openComment = "";
        String closeComment = "";
        String openGraph = "";
        String closeGraph = "";
        if (mono != 1 && mono != -1) {
            throw new IllegalArgumentException("mono must be 1 or -1");
        }
        switch (graphSoft) {
            case 0: {
                openComment = "# ";
                closeComment = "";
                openGraph = "";
                closeGraph = PrintfFormat.NEWLINE;
                break;
            }
            case 1: {
                openComment = "(* ";
                closeComment = " *)";
                openGraph = "points = { " + PrintfFormat.NEWLINE;
                closeGraph = "}" + PrintfFormat.NEWLINE;
            }
        }
        sb.append(openComment + "----------------------------------" + closeComment + PrintfFormat.NEWLINE);
        sb.append(openComment + PrintfFormat.s(-70, desc) + closeComment + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        sb.append(openGraph);
        double h = (b - a) / (double)m;
        double yprec = mono == 1 ? -1.7976931348623157E308 : (mono == -1 ? Double.MAX_VALUE : 0.0);
        for (int i = 0; i <= m; ++i) {
            double x = a + (double)i * h;
            double y = mono == 1 ? dist.cdf(x) : dist.barF(x);
            switch (graphSoft) {
                case 1: {
                    sb.append(GofFormat.formatMath2(x, y));
                    if (i >= m) break;
                    sb.append(',');
                    break;
                }
                default: {
                    sb.append(PrintfFormat.g(20, 14, x) + "      " + PrintfFormat.g(20, 14, y));
                }
            }
            switch (mono) {
                case 1: {
                    if (!(y < yprec)) break;
                    sb.append("    " + openComment + "  DECREASING" + closeComment);
                    break;
                }
                case -1: {
                    if (!(y > yprec)) break;
                    sb.append("    " + openComment + "  INCREASING" + closeComment);
                    break;
                }
            }
            sb.append(PrintfFormat.NEWLINE);
            yprec = y;
        }
        sb.append(closeGraph);
        return sb.toString();
    }

    public static String drawCdf(ContinuousDistribution dist, double a, double b, int m, String desc) {
        return GofFormat.graphFunc(dist, a, b, m, 1, desc);
    }

    public static String drawDensity(ContinuousDistribution dist, double a, double b, int m, String desc) {
        StringBuffer sb = new StringBuffer();
        String openComment = "";
        String closeComment = "";
        String openGraph = "";
        String closeGraph = "";
        switch (graphSoft) {
            case 0: {
                openComment = "# ";
                closeComment = "";
                openGraph = "";
                closeGraph = PrintfFormat.NEWLINE;
                break;
            }
            case 1: {
                openComment = "(* ";
                closeComment = " *)";
                openGraph = "points = { " + PrintfFormat.NEWLINE;
                closeGraph = "}" + PrintfFormat.NEWLINE;
            }
        }
        sb.append(openComment + "----------------------------------" + closeComment + PrintfFormat.NEWLINE);
        sb.append(openComment + PrintfFormat.s(-70, desc) + closeComment + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        sb.append(openGraph);
        double h = (b - a) / (double)m;
        for (int i = 0; i <= m; ++i) {
            double x = a + (double)i * h;
            double y = dist.density(x);
            switch (graphSoft) {
                case 1: {
                    sb.append(GofFormat.formatMath2(x, y));
                    if (i >= m) break;
                    sb.append(',');
                    break;
                }
                default: {
                    sb.append(PrintfFormat.g(16, 8, x) + "      " + PrintfFormat.g(16, 8, y));
                }
            }
            sb.append(PrintfFormat.NEWLINE);
        }
        sb.append(closeGraph);
        return sb.toString();
    }

    public static String graphDistUnif(DoubleArrayList data, String desc) {
        double[] u = data.elements();
        int n = data.size();
        double unSurN = 1.0 / (double)n;
        StringBuffer sb = new StringBuffer();
        switch (graphSoft) {
            case 0: {
                sb.append("#----------------------------------" + PrintfFormat.NEWLINE);
                sb.append("# " + PrintfFormat.s(-70, desc) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
                sb.append(PrintfFormat.g(16, 8, 0.0) + "  " + PrintfFormat.g(16, 8, 0.0) + PrintfFormat.NEWLINE);
                for (int i = 0; i < n; ++i) {
                    sb.append(PrintfFormat.g(16, 8, u[i]) + "  " + PrintfFormat.g(16, 8, (double)(i + 1) * unSurN) + PrintfFormat.NEWLINE);
                }
                sb.append(PrintfFormat.g(16, 8, 1.0) + "  " + PrintfFormat.g(16, 8, 1.0) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
                break;
            }
            case 1: {
                sb.append("(*----------------------------------*)" + PrintfFormat.NEWLINE);
                sb.append("(* " + PrintfFormat.s(-70, desc) + PrintfFormat.NEWLINE + " *)" + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE + "points = { " + PrintfFormat.NEWLINE);
                sb.append(GofFormat.formatMath2(0.0, 0.0) + "," + PrintfFormat.NEWLINE);
                for (int i = 0; i < n; ++i) {
                    sb.append(GofFormat.formatMath2(u[i], (double)(i + 1) * unSurN) + "," + PrintfFormat.NEWLINE);
                }
                sb.append(GofFormat.formatMath2(1.0, 1.0) + PrintfFormat.NEWLINE);
                break;
            }
            default: {
                throw new IllegalArgumentException("graphSoft unknown");
            }
        }
        return sb.toString();
    }

    public static String formatp0(double p) {
        if (p >= 0.01 && p <= 0.99) {
            return PrintfFormat.format(8, 2, 1, p);
        }
        if (p < EPSILONP) {
            return "   eps  ";
        }
        if (p < 0.01) {
            return PrintfFormat.format(8, 2, 2, p);
        }
        if (p >= 1.0 - EPSILONP) {
            return " 1 - eps ";
        }
        return " 1 - " + PrintfFormat.g(8, 2, 1.0 - p);
    }

    public static String formatp1(double p) {
        StringBuffer sb = new StringBuffer();
        sb.append("Significance level of test            :" + GofFormat.formatp0(p));
        if (p < SUSPECTP || p > 1.0 - SUSPECTP) {
            sb.append("    *****");
        }
        sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String formatp2(double x, double p) {
        return PrintfFormat.format(8, 2, 1, x) + PrintfFormat.NEWLINE + GofFormat.formatp1(p);
    }

    public static String formatp3(String testName, double x, double p) {
        String SLT = "Significance level of test";
        int l = Math.max("Significance level of test".length(), testName.length());
        PrintfFormat pf = new PrintfFormat();
        pf.append(-l, testName).append(" : ").append(8, 2, 1, x).append(PrintfFormat.NEWLINE);
        pf.append(-l, "Significance level of test").append(" : ").append(GofFormat.formatp0(p));
        if (p < SUSPECTP || p > 1.0 - SUSPECTP) {
            pf.append("    *****");
        }
        pf.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return pf.toString();
    }

    public static String formatChi2(int k, int d, double chi2) {
        StringBuffer sb = new StringBuffer();
        sb.append("Chi2 statistic                        : " + PrintfFormat.format(8, 2, 1, chi2));
        sb.append(PrintfFormat.NEWLINE + "p-value                               : " + GofFormat.formatp0(GofStat.pDisc(ChiSquareDist.cdf(k - 1, d, chi2), ChiSquareDist.barF(k - 1, d, chi2))));
        sb.append(PrintfFormat.NEWLINE + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String formatKS(int n, double dp, double dm, double d) {
        return "Kolmogorov-Smirnov+ statistic = D+    :" + GofFormat.formatp2(dp, KolmogorovSmirnovPlusDist.barF(n, dp)) + "Kolmogorov-Smirnov- statistic = D-    :" + GofFormat.formatp2(dm, KolmogorovSmirnovPlusDist.barF(n, dm)) + "Kolmogorov-Smirnov statistic = D      :" + GofFormat.formatp2(d, KolmogorovSmirnovDistQuick.barF(n, d)) + PrintfFormat.NEWLINE + PrintfFormat.NEWLINE;
    }

    public static String formatKS(DoubleArrayList data, ContinuousDistribution dist) {
        double[] v = data.elements();
        int n = data.size();
        DoubleArrayList dataUnif = GofStat.unifTransform(data, dist);
        dataUnif.quickSortFromTo(0, dataUnif.size() - 1);
        double[] ret = GofStat.kolmogorovSmirnov(dataUnif);
        return GofFormat.formatKS(n, ret[0], ret[1], ret[2]);
    }

    public static String formatKSJumpOne(int n, double a, double dp) {
        double d = 1.0 - FDist.kolmogorovSmirnovPlusJumpOne(n, a, dp);
        return PrintfFormat.NEWLINE + "Kolmogorov-Smirnov+ statistic = D+    : " + PrintfFormat.g(8, 2, dp) + PrintfFormat.NEWLINE + GofFormat.formatp1(d) + PrintfFormat.NEWLINE;
    }

    public static String formatKSJumpOne(DoubleArrayList data, ContinuousDistribution dist, double a) {
        double[] v = data.elements();
        int n = data.size();
        DoubleArrayList dataUnif = GofStat.unifTransform(data, dist);
        dataUnif.quickSortFromTo(0, dataUnif.size() - 1);
        double[] ret = GofStat.kolmogorovSmirnovJumpOne(dataUnif, a);
        return GofFormat.formatKSJumpOne(n, a, ret[0]);
    }

    private static void initActiveTests() {
        activeTests = new boolean[9];
        for (int i = 0; i < activeTests.length; ++i) {
            GofFormat.activeTests[i] = false;
        }
        GofFormat.activeTests[1] = true;
        GofFormat.activeTests[0] = true;
        GofFormat.activeTests[8] = true;
        GofFormat.activeTests[7] = true;
        GofFormat.activeTests[3] = true;
    }

    public static void tests(DoubleArrayList sortedData, double[] sVal) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        double a2 = 0.0;
        double dm = 0.0;
        double dp = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (sVal.length != 9) {
            throw new IllegalArgumentException("sVal must be of size NTESTTYPES.");
        }
        if (n == 1) {
            sVal[0] = 1.0 - u[0];
            sVal[7] = u[0];
            return;
        }
        double unSurN = 1.0 / (double)n;
        double w2 = unSurN / 12.0;
        double sumZ = 0.0;
        for (int i = 0; i < n; ++i) {
            double d1 = u[i] - (double)i * unSurN;
            double d2 = (double)(i + 1) * unSurN - u[i];
            if (d1 > dm) {
                dm = d1;
            }
            if (d2 > dp) {
                dp = d2;
            }
            sumZ += u[i];
            double w = u[i] - ((double)i + 0.5) * unSurN;
            w2 += w * w;
            double ui = u[i];
            double u1 = 1.0 - ui;
            if (ui < GofStat.EPSILONAD) {
                ui = GofStat.EPSILONAD;
            } else if (u1 < GofStat.EPSILONAD) {
                u1 = GofStat.EPSILONAD;
            }
            a2 += (double)(2 * i + 1) * Math.log(ui) + (double)(1 + 2 * (n - i - 1)) * Math.log(u1);
        }
        sVal[2] = dm > dp ? dm : dp;
        sVal[1] = dm;
        sVal[0] = dp;
        sumZ = sumZ * unSurN - 0.5;
        sVal[4] = w2;
        sVal[5] = Math.sqrt(n) * (dp + sumZ);
        sVal[6] = w2 - sumZ * sumZ * (double)n;
        sVal[3] = (double)(-n) - a2 * unSurN;
        sVal[7] = sumZ + 0.5;
    }

    public static void tests(DoubleArrayList data, ContinuousDistribution dist, double[] sVal) {
        double[] v = data.elements();
        int n = data.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        DoubleArrayList sortedData = GofStat.unifTransform(data, dist);
        sortedData.quickSortFromTo(0, sortedData.size() - 1);
        GofFormat.tests(sortedData, sVal);
        if (n == 1) {
            sVal[7] = v[0];
        }
    }

    public static void activeTests(DoubleArrayList sortedData, double[] sVal, double[] pVal) {
        double[] u = sortedData.elements();
        int n = sortedData.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (sVal.length != 9 || pVal.length != 9) {
            throw new IllegalArgumentException("sVal and pVal must be of length NTESTTYPES.");
        }
        if (n == 1) {
            sVal[0] = 1.0 - u[0];
            pVal[0] = 1.0 - u[0];
            pVal[7] = pVal[0];
            return;
        }
        GofFormat.tests(sortedData, sVal);
        if (activeTests.length != 9) {
            GofFormat.initActiveTests();
            System.err.println("activeTests was invalid, it was reinitialized.");
        }
        if (activeTests[0]) {
            pVal[0] = KolmogorovSmirnovPlusDist.barF(n, sVal[0]);
        }
        if (activeTests[1]) {
            pVal[1] = KolmogorovSmirnovPlusDist.barF(n, sVal[1]);
        }
        if (activeTests[2]) {
            pVal[2] = KolmogorovSmirnovDistQuick.barF(n, sVal[2]);
        }
        if (activeTests[3]) {
            pVal[3] = AndersonDarlingDistQuick.barF(n, sVal[3]);
        }
        if (activeTests[4]) {
            pVal[4] = CramerVonMisesDist.barF(n, sVal[4]);
        }
        if (activeTests[5]) {
            pVal[5] = WatsonGDist.barF(n, sVal[5]);
        }
        if (activeTests[6]) {
            pVal[6] = WatsonUDist.barF(n, sVal[6]);
        }
    }

    public static void activeTests(DoubleArrayList data, ContinuousDistribution dist, double[] sVal, double[] pVal) {
        double[] v = data.elements();
        int n = data.size();
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        DoubleArrayList sortedData = GofStat.unifTransform(data, dist);
        sortedData.quickSortFromTo(0, sortedData.size() - 1);
        GofFormat.activeTests(sortedData, sVal, pVal);
        if (n == 1) {
            sVal[7] = v[0];
        }
    }

    public static String formatActiveTests(int n, double[] sVal, double[] pVal) {
        if (activeTests.length != 9) {
            GofFormat.initActiveTests();
            System.err.println("activeTests was invalid, it was reinitialized.");
        }
        if (sVal.length != 9 || pVal.length != 9) {
            throw new IllegalArgumentException("The length of sVal and pVal must be NTESTTYPES.");
        }
        if (n == 1) {
            return GofFormat.formatp1(pVal[0]);
        }
        StringBuffer sb = new StringBuffer(PrintfFormat.NEWLINE);
        if (activeTests[0]) {
            sb.append("Kolmogorov-Smirnov+ statistic = D+    :" + GofFormat.formatp2(sVal[0], pVal[0]));
        }
        if (activeTests[1]) {
            sb.append("Kolmogorov-Smirnov- statistic = D-    :" + GofFormat.formatp2(sVal[1], pVal[1]));
        }
        if (activeTests[2]) {
            sb.append("Kolmogorov-Smirnov statistic  = D     :" + GofFormat.formatp2(sVal[2], pVal[2]));
        }
        if (activeTests[3]) {
            sb.append("Anderson-Darling statistic = A2       :" + GofFormat.formatp2(sVal[3], pVal[3]));
        }
        if (activeTests[4]) {
            sb.append("Cramer-von Mises statistic = W2       :" + GofFormat.formatp2(sVal[4], pVal[4]));
        }
        if (activeTests[5]) {
            sb.append("Watson statistic = G                  :" + GofFormat.formatp2(sVal[5], pVal[5]));
        }
        if (activeTests[6]) {
            sb.append("Watson statistic = U2                 :" + GofFormat.formatp2(sVal[6], pVal[6]));
        }
        sb.append(PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public static String iterSpacingsTests(DoubleArrayList sortedData, int k, boolean printval, boolean graph, PrintWriter f) {
        int n = sortedData.size();
        DoubleArrayList sortedDataCopy = (DoubleArrayList)sortedData.clone();
        DoubleArrayList diffArrayList = new DoubleArrayList(sortedData.size() + 2);
        double[] sVal = new double[9];
        double[] pVal = new double[9];
        StringBuffer sb = new StringBuffer(PrintfFormat.NEWLINE);
        for (int j = 1; j <= k; ++j) {
            sb.append("-----------------------------------" + PrintfFormat.NEWLINE + "EDF Tests after \"iterateSpacings\", level : " + PrintfFormat.d(2, j) + PrintfFormat.NEWLINE);
            GofStat.diff(sortedDataCopy, diffArrayList, 0, n - 1, 0.0, 1.0);
            GofStat.iterateSpacings(sortedDataCopy, diffArrayList);
            sortedDataCopy.quickSortFromTo(0, sortedDataCopy.size() - 1);
            GofFormat.activeTests(sortedDataCopy, sVal, pVal);
            sb.append(GofFormat.formatActiveTests(n, sVal, pVal));
            String desc = "Values of Uniforms after iterateSpacings, level " + PrintfFormat.d(2, j);
            if (printval) {
                sb.append(desc + PrintfFormat.NEWLINE + "------------------------" + PrintfFormat.NEWLINE);
                sb.append(sortedDataCopy + PrintfFormat.NEWLINE);
            }
            if (graph && f != null) {
                f.print(GofFormat.graphDistUnif(sortedDataCopy, desc));
                continue;
            }
            if (!graph || f != null) continue;
            sb.append(GofFormat.graphDistUnif(sortedDataCopy, desc));
        }
        return sb.toString();
    }

    public static String iterPowRatioTests(DoubleArrayList sortedData, int k, boolean printval, boolean graph, PrintWriter f) {
        int n = sortedData.size();
        DoubleArrayList sortedDataCopy = (DoubleArrayList)sortedData.clone();
        double[] sVal = new double[9];
        double[] pVal = new double[9];
        StringBuffer sb = new StringBuffer(PrintfFormat.NEWLINE);
        for (int i = 1; i <= k; ++i) {
            GofStat.powerRatios(sortedDataCopy);
            sb.append("-----------------------------------" + PrintfFormat.NEWLINE + "EDF Tests after \"powerRatios\", level : " + PrintfFormat.d(2, i) + PrintfFormat.NEWLINE);
            sortedDataCopy.quickSortFromTo(0, sortedDataCopy.size() - 1);
            GofFormat.activeTests(sortedDataCopy, sVal, pVal);
            sb.append(GofFormat.formatActiveTests(n, sVal, pVal));
            String desc = "Values of Uniforms after PowerRatios, level " + PrintfFormat.d(2, i);
            if (printval) {
                sb.append(desc + PrintfFormat.NEWLINE + "--------------------------" + PrintfFormat.NEWLINE);
                sb.append(sortedDataCopy + PrintfFormat.NEWLINE);
            }
            if (graph && f != null) {
                f.print(GofFormat.graphDistUnif(sortedDataCopy, desc));
                continue;
            }
            if (!graph || f != null) continue;
            sb.append(GofFormat.graphDistUnif(sortedDataCopy, desc));
        }
        return sb.toString();
    }

    static {
        GofFormat.initActiveTests();
    }
}

