/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.DcoreBLAS;
import org.netlib.util.intW;

class Pdpotrf {
    private Pdpotrf() {
    }

    protected static void plasma_pDPOTRF(int uplo, int N, double[] A, int A_offset, int NB, int NBNBSIZE, int NT, intW INFO, int cores_num, int my_core_id) {
        int[] progress = Dcommon.plasma_aux.progress;
        int k = 0;
        int m = my_core_id;
        while (m >= NT) {
            m = m - NT + ++k;
        }
        int n = 0;
        while (k < NT && m < NT) {
            int next_n = n;
            int next_m = m;
            int next_k = k;
            if (++next_n > next_k) {
                next_m += cores_num;
                while (next_m >= NT && next_k < NT) {
                    next_m = next_m - NT + ++next_k;
                }
                next_n = 0;
            }
            if (m == k) {
                if (n == k) {
                    if (uplo == 122) {
                        DcoreBLAS.core_DPOTRF(122, k == NT - 1 ? N - k * NB : NB, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB, INFO);
                    } else {
                        DcoreBLAS.core_DPOTRF(121, k == NT - 1 ? N - k * NB : NB, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB, INFO);
                    }
                    if (INFO.val != 0) {
                        INFO.val += NB * k;
                    }
                    progress[k + NT * k] = 1;
                } else {
                    while (progress[k + NT * n] != 1 && INFO.val == 0) {
                        Dcommon.delay();
                    }
                    if (uplo == 122) {
                        DcoreBLAS.core_DSYRK(122, 111, k == NT - 1 ? N - k * NB : NB, NB, -1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * n, NB, 1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB);
                    } else {
                        DcoreBLAS.core_DSYRK(121, 112, k == NT - 1 ? N - k * NB : NB, NB, -1.0, A, A_offset + NBNBSIZE * n + NBNBSIZE * NT * k, NB, 1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB);
                    }
                }
            } else if (n == k) {
                while (progress[k + NT * k] != 1 && INFO.val == 0) {
                    Dcommon.delay();
                }
                if (uplo == 122) {
                    DcoreBLAS.core_DTRSM(142, 122, 112, 131, m == NT - 1 ? N - m * NB : NB, NB, 1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB, A, A_offset + NBNBSIZE * m + NBNBSIZE * NT * k, NB);
                } else {
                    DcoreBLAS.core_DTRSM(141, 121, 112, 131, NB, m == NT - 1 ? N - m * NB : NB, 1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * k, NB, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * m, NB);
                }
                progress[m + NT * k] = 1;
            } else {
                while (progress[k + NT * n] != 1 && INFO.val == 0) {
                    Dcommon.delay();
                }
                while (progress[m + NT * n] != 1 && INFO.val == 0) {
                    Dcommon.delay();
                }
                if (uplo == 122) {
                    DcoreBLAS.core_DGEMM(111, 112, m == NT - 1 ? N - m * NB : NB, NB, NB, -1.0, A, A_offset + NBNBSIZE * m + NBNBSIZE * NT * n, NB, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * n, NB, 1.0, A, A_offset + NBNBSIZE * m + NBNBSIZE * NT * k, NB);
                } else {
                    DcoreBLAS.core_DGEMM(112, 111, NB, m == NT - 1 ? N - m * NB : NB, NB, -1.0, A, A_offset + NBNBSIZE * n + NBNBSIZE * NT * k, NB, A, A_offset + NBNBSIZE * n + NBNBSIZE * NT * m, NB, 1.0, A, A_offset + NBNBSIZE * k + NBNBSIZE * NT * m, NB);
                }
            }
            if (INFO.val != 0) {
                return;
            }
            n = next_n;
            m = next_m;
            k = next_k;
        }
    }
}

