/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.Dallocate;
import edu.emory.mathcs.jplasma.tdouble.Dauxiliary;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Pdpotrf;
import edu.emory.mathcs.jplasma.tdouble.Pdtrsm;
import java.util.concurrent.locks.Lock;

class Dposv {
    private Dposv() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int plasma_DPOSV(int uplo, int N, int NRHS, double[] A, int A_offset, int LDA, double[] B, int B_offset, int LDB) {
        double[] bdl_mem;
        int NTRHS;
        if (!Dcommon.plasma_cntrl.initialized) {
            Dauxiliary.plasma_warning("plasma_DPOSV", "PLASMA not initialized");
            return -1;
        }
        if (uplo != 121 && uplo != 122) {
            Dauxiliary.plasma_error("plasma_DPOSV", "illegal value of uplo");
            return -4;
        }
        if (N < 0) {
            Dauxiliary.plasma_error("plasma_DPOSV", "illegal value of N");
            return -4;
        }
        if (NRHS < 0) {
            Dauxiliary.plasma_error("plasma_DPOSV", "illegal value of NRHS");
            return -4;
        }
        if (LDA < Math.max(1, N)) {
            Dauxiliary.plasma_error("plasma_DPOSV", "illegal value of LDA");
            return -4;
        }
        if (LDB < Math.max(1, N)) {
            Dauxiliary.plasma_error("plasma_DPOSV", "illegal value of LDB");
            return -4;
        }
        if (Math.min(N, NRHS) == 0) {
            return 0;
        }
        int status = Dauxiliary.plasma_tune(2, N, N, NRHS);
        if (status != 0) {
            Dauxiliary.plasma_error("plasma_DPOSV", "plasma_tune() failed");
            return status;
        }
        int NB = Dcommon.plasma_cntrl.NB;
        int NT = N % NB == 0 ? N / NB : N / NB + 1;
        int size_elems = Math.max(NT * NT, NT * (NTRHS = NRHS % NB == 0 ? NRHS / NB : NRHS / NB + 1));
        if (Dcommon.plasma_cntrl.progress_size_elems < size_elems) {
            status = Dallocate.plasma_free_aux_progress();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DPOSV", "plasma_free_aux_progress() failed");
            }
            if ((status = Dallocate.plasma_alloc_aux_progress(size_elems)) != 0) {
                Dauxiliary.plasma_error("plasma_DPOSV", "plasma_alloc_aux_progress() failed");
                return status;
            }
        }
        double[] Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
        int Abdl_offset = 0;
        double[] Bbdl = bdl_mem;
        int Bbdl_offset = NT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
        size_elems = Bbdl_offset + NT * NTRHS * Dcommon.plasma_cntrl.NBNBSIZE;
        if (Dcommon.plasma_cntrl.bdl_size_elems < size_elems) {
            status = Dallocate.plasma_free_aux_bdl();
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DPOSV", "plasma_free_aux_bdl() failed");
                return status;
            }
            status = Dallocate.plasma_alloc_aux_bdl(size_elems);
            if (status != 0) {
                Dauxiliary.plasma_error("plasma_DPOSV", "plasma_alloc_aux_bdl() failed");
                return status;
            }
            Abdl = bdl_mem = Dcommon.plasma_aux.bdl_mem;
            Abdl_offset = 0;
            Bbdl = bdl_mem;
            Bbdl_offset = NT * NT * Dcommon.plasma_cntrl.NBNBSIZE;
        }
        Dcommon.plasma_args.F77 = A;
        Dcommon.plasma_args.F77_offset = A_offset;
        Dcommon.plasma_args.A = Abdl;
        Dcommon.plasma_args.A_offset = Abdl_offset;
        Dcommon.plasma_args.M = N;
        Dcommon.plasma_args.N = N;
        Dcommon.plasma_args.LDA = LDA;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = NT;
        Dcommon.plasma_args.NT = NT;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Lock lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 9;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_args.F77 = B;
        Dcommon.plasma_args.F77_offset = B_offset;
        Dcommon.plasma_args.A = Bbdl;
        Dcommon.plasma_args.A_offset = Bbdl_offset;
        Dcommon.plasma_args.M = N;
        Dcommon.plasma_args.N = NRHS;
        Dcommon.plasma_args.LDA = LDB;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.MT = NT;
        Dcommon.plasma_args.NT = NTRHS;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 9;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        DbdlConvert.plasma_lapack_to_bdl(Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_args.uplo = uplo;
        Dcommon.plasma_args.N = N;
        Dcommon.plasma_args.A = Abdl;
        Dcommon.plasma_args.A_offset = Abdl_offset;
        Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
        Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
        Dcommon.plasma_args.NT = NT;
        Dauxiliary.plasma_clear_aux_progress(NT * NT, 0);
        lock = Dcommon.plasma_cntrl.action_mutex;
        lock.lock();
        try {
            Dcommon.plasma_cntrl.action = 5;
            Dcommon.plasma_cntrl.action_condt.signalAll();
        }
        finally {
            lock.unlock();
        }
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        Dcommon.plasma_cntrl.action = 0;
        Pdpotrf.plasma_pDPOTRF(Dcommon.plasma_args.uplo, Dcommon.plasma_args.N, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.INFO, Dcommon.plasma_cntrl.cores_num, 0);
        Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        if (Dcommon.plasma_args.INFO.val == 0) {
            Dcommon.plasma_args.uplo = uplo;
            Dcommon.plasma_args.trans = uplo == 121 ? 112 : 111;
            Dcommon.plasma_args.diag = 131;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.NRHS = NRHS;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.MT = NT;
            Dcommon.plasma_args.B = Bbdl;
            Dcommon.plasma_args.B_offset = Bbdl_offset;
            Dcommon.plasma_args.MTB = NT;
            Dcommon.plasma_args.NTRHS = NTRHS;
            Dauxiliary.plasma_clear_aux_progress(NT * NTRHS, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 4;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdtrsm.plasma_pDTRSM(141, Dcommon.plasma_args.uplo, Dcommon.plasma_args.trans, Dcommon.plasma_args.diag, Dcommon.plasma_args.N, Dcommon.plasma_args.NRHS, 1.0, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.MT, Dcommon.plasma_args.B, Dcommon.plasma_args.B_offset, Dcommon.plasma_args.MTB, Dcommon.plasma_args.NTRHS, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.uplo = uplo;
            Dcommon.plasma_args.trans = uplo == 121 ? 111 : 112;
            Dcommon.plasma_args.diag = 131;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.NRHS = NRHS;
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.MT = NT;
            Dcommon.plasma_args.B = Bbdl;
            Dcommon.plasma_args.B_offset = Bbdl_offset;
            Dcommon.plasma_args.MTB = NT;
            Dcommon.plasma_args.NTRHS = NTRHS;
            Dauxiliary.plasma_clear_aux_progress(NT * NTRHS, -1);
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 4;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            Pdtrsm.plasma_pDTRSM(141, Dcommon.plasma_args.uplo, Dcommon.plasma_args.trans, Dcommon.plasma_args.diag, Dcommon.plasma_args.N, Dcommon.plasma_args.NRHS, 1.0, Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.NB, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_args.NT, Dcommon.plasma_args.MT, Dcommon.plasma_args.B, Dcommon.plasma_args.B_offset, Dcommon.plasma_args.MTB, Dcommon.plasma_args.NTRHS, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.A = Abdl;
            Dcommon.plasma_args.A_offset = Abdl_offset;
            Dcommon.plasma_args.F77 = A;
            Dcommon.plasma_args.F77_offset = A_offset;
            Dcommon.plasma_args.M = N;
            Dcommon.plasma_args.N = N;
            Dcommon.plasma_args.LDA = LDA;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = NT;
            Dcommon.plasma_args.NT = NT;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 10;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_args.A = Bbdl;
            Dcommon.plasma_args.A_offset = Bbdl_offset;
            Dcommon.plasma_args.F77 = B;
            Dcommon.plasma_args.F77_offset = B_offset;
            Dcommon.plasma_args.M = N;
            Dcommon.plasma_args.N = NRHS;
            Dcommon.plasma_args.LDA = LDB;
            Dcommon.plasma_args.NB = Dcommon.plasma_cntrl.NB;
            Dcommon.plasma_args.MT = NT;
            Dcommon.plasma_args.NT = NTRHS;
            Dcommon.plasma_args.NBNBSIZE = Dcommon.plasma_cntrl.NBNBSIZE;
            lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                Dcommon.plasma_cntrl.action = 10;
                Dcommon.plasma_cntrl.action_condt.signalAll();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
            Dcommon.plasma_cntrl.action = 0;
            DbdlConvert.plasma_bdl_to_lapack(Dcommon.plasma_args.A, Dcommon.plasma_args.A_offset, Dcommon.plasma_args.F77, Dcommon.plasma_args.F77_offset, Dcommon.plasma_args.M, Dcommon.plasma_args.N, Dcommon.plasma_args.LDA, Dcommon.plasma_args.NB, Dcommon.plasma_args.MT, Dcommon.plasma_args.NT, Dcommon.plasma_args.NBNBSIZE, Dcommon.plasma_cntrl.cores_num, 0);
            Barrier.plasma_barrier(0, Dcommon.plasma_cntrl.cores_num);
        }
        return Dcommon.plasma_args.INFO.val;
    }
}

