/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

import edu.emory.mathcs.jplasma.Barrier;
import edu.emory.mathcs.jplasma.tdouble.DbdlConvert;
import edu.emory.mathcs.jplasma.tdouble.Dcommon;
import edu.emory.mathcs.jplasma.tdouble.Dglobal;
import edu.emory.mathcs.jplasma.tdouble.Pdgelqf;
import edu.emory.mathcs.jplasma.tdouble.Pdgeqrf;
import edu.emory.mathcs.jplasma.tdouble.Pdgetrf;
import edu.emory.mathcs.jplasma.tdouble.Pdormqr;
import edu.emory.mathcs.jplasma.tdouble.Pdpotrf;
import edu.emory.mathcs.jplasma.tdouble.Pdtrsm;
import edu.emory.mathcs.jplasma.tdouble.Pdtrsmpl;
import java.util.concurrent.locks.Lock;

class DcoreControl
implements Runnable {
    private int my_core_id;

    protected DcoreControl(int core_id) {
        this.my_core_id = core_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int action = 0;
        int cores_num = Dcommon.plasma_cntrl.cores_num;
        Dglobal.Plasma_args args = Dcommon.plasma_args;
        Barrier.plasma_barrier(this.my_core_id, cores_num);
        while (true) {
            Lock lock = Dcommon.plasma_cntrl.action_mutex;
            lock.lock();
            try {
                while ((action = Dcommon.plasma_cntrl.action) == 0) {
                    Dcommon.plasma_cntrl.action_condt.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
            Barrier.plasma_barrier(this.my_core_id, cores_num);
            switch (action) {
                case 2: {
                    Pdgeqrf.plasma_pDGEQRF(args.M, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.IBNBSIZE, args.IB, args.MT, args.NT, args.T, args.T_offset, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 6: {
                    Pdgelqf.plasma_pDGELQF(args.M, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.IBNBSIZE, args.IB, args.MT, args.NT, args.T, args.T_offset, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 3: {
                    Pdormqr.plasma_pDORMQR(args.M, args.NRHS, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.IBNBSIZE, args.IB, args.MT, args.NTRHS, args.NT, args.T, args.T_offset, args.B, args.B_offset, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 4: {
                    Pdtrsm.plasma_pDTRSM(141, args.uplo, args.trans, args.diag, args.N, args.NRHS, 1.0, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.NT, args.MT, args.B, args.B_offset, args.MTB, args.NTRHS, cores_num, this.my_core_id);
                    break;
                }
                case 5: {
                    Pdpotrf.plasma_pDPOTRF(args.uplo, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.NT, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 7: {
                    Pdgetrf.plasma_pDGETRF(args.M, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.IBNBSIZE, args.IB, args.MT, args.NT, args.L, args.L_offset, args.IPIV, args.IPIV_offset, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 8: {
                    Pdtrsmpl.plasma_pDTRSMPL(args.M, args.NRHS, args.N, args.A, args.A_offset, args.NB, args.NBNBSIZE, args.IBNBSIZE, args.IB, args.MT, args.NTRHS, args.NT, args.L, args.L_offset, args.IPIV, args.IPIV_offset, args.B, args.B_offset, args.INFO, cores_num, this.my_core_id);
                    break;
                }
                case 9: {
                    DbdlConvert.plasma_lapack_to_bdl(args.F77, args.F77_offset, args.A, args.A_offset, args.M, args.N, args.LDA, args.NB, args.MT, args.NT, args.NBNBSIZE, cores_num, this.my_core_id);
                    break;
                }
                case 10: {
                    DbdlConvert.plasma_bdl_to_lapack(args.A, args.A_offset, args.F77, args.F77_offset, args.M, args.N, args.LDA, args.NB, args.MT, args.NT, args.NBNBSIZE, cores_num, this.my_core_id);
                    break;
                }
                case 1: {
                    return;
                }
                default: {
                    return;
                }
            }
            Barrier.plasma_barrier(this.my_core_id, cores_num);
        }
    }
}

