/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.benchmark;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import org.netlib.lapack.Dgels;
import org.netlib.util.intW;

public class DgelsBenchmark {
    private static void dgelsBenchmarkJPlasma(int M, int N, int NRHS, int NITERS, int NTHREADS) {
        ConcurrencyUtils.setNumberOfThreads(NTHREADS);
        int LDA = M;
        int LDB = Math.max(M, N);
        double[] A = new double[M * N];
        double[] B = new double[LDB * NRHS];
        double avtime = 0.0;
        Dplasma.plasma_Init(M, N, 1);
        for (int k = 0; k < NITERS + 2; ++k) {
            int j;
            int i;
            for (i = 0; i < M; ++i) {
                for (j = 0; j < N; ++j) {
                    A[M * j + i] = 0.5 - Math.random();
                }
            }
            for (i = 0; i < LDB; ++i) {
                for (j = 0; j < NRHS; ++j) {
                    B[M * j + i] = Math.random();
                }
            }
            double[] T = Dplasma.plasma_Allocate_T(M, N);
            double temp = System.nanoTime();
            int info = Dplasma.plasma_DGELS(111, M, N, NRHS, A, 0, LDA, T, 0, B, 0, LDB);
            temp = (double)System.nanoTime() - temp;
            if (k >= 2) {
                avtime += temp;
            }
            if (info == 0) continue;
            System.err.println("failure with error " + info);
        }
        System.out.println("Average execution time of JPlasma DGELS (" + M + "x" + N + ", " + NRHS + " right-hand sides, " + NTHREADS + " threads): " + avtime / (double)NITERS / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    private static void dgelsBenchmarkJLAPACK(int M, int N, int NRHS, int NITERS) {
        int LDA = M;
        int LDB = Math.max(M, N);
        int MN = Math.min(M, N);
        int LWORK = Math.max(1, MN + Math.max(MN, NRHS));
        double[] A = new double[M * N];
        double[] B = new double[LDB * NRHS];
        double avtime = 0.0;
        Dplasma.plasma_Init(M, N, 1);
        for (int k = 0; k < NITERS + 2; ++k) {
            int j;
            int i;
            for (i = 0; i < M; ++i) {
                for (j = 0; j < N; ++j) {
                    A[M * j + i] = 0.5 - Math.random();
                }
            }
            for (i = 0; i < LDB; ++i) {
                for (j = 0; j < NRHS; ++j) {
                    B[M * j + i] = Math.random();
                }
            }
            double[] WORK = new double[LWORK];
            intW info = new intW(0);
            double temp = System.nanoTime();
            Dgels.dgels((String)"N", (int)M, (int)N, (int)NRHS, (double[])A, (int)0, (int)LDA, (double[])B, (int)0, (int)LDB, (double[])WORK, (int)0, (int)LWORK, (intW)info);
            temp = (double)System.nanoTime() - temp;
            if (k >= 2) {
                avtime += temp;
            }
            if (info.val == 0) continue;
            System.err.println("failure with error " + info);
        }
        System.out.println("Average execution time of JLAPACK DGELS (" + M + "x" + N + ", " + NRHS + " right-hand sides): " + avtime / (double)NITERS / 1000000.0 + " milliseconds");
        Dplasma.plasma_Finalize();
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.out.println("Usage: java edu.emory.mathcs.jplasma.benchmark.DgelsBenchmark M N NRHS NITERS NTHREADS");
            System.exit(1);
        }
        int M = Integer.parseInt(args[0]);
        int N = Integer.parseInt(args[1]);
        int NRHS = Integer.parseInt(args[2]);
        int NITERS = Integer.parseInt(args[3]);
        int NTHREADS = Integer.parseInt(args[4]);
        DgelsBenchmark.dgelsBenchmarkJPlasma(M, N, NRHS, NITERS, NTHREADS);
        System.exit(0);
    }
}

