/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Barrier {
    private static CountDownLatch workersLatch;
    private static Lock masterLock;
    private static Condition masterCondition;

    public static void plasma_barrier_init(int num_workers) {
        workersLatch = new CountDownLatch(num_workers);
        masterLock = new ReentrantLock();
        masterCondition = masterLock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void plasma_barrier(int my_core_id, int cores_num) {
        if (my_core_id == 0) {
            try {
                workersLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            masterLock.lock();
            try {
                workersLatch = new CountDownLatch(cores_num - 1);
                masterCondition.signalAll();
            }
            finally {
                masterLock.unlock();
            }
        }
        masterLock.lock();
        try {
            workersLatch.countDown();
            masterCondition.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            masterLock.unlock();
        }
    }
}

