/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.util.Browser;
import com.edsdev.jconvert.util.JConvertProperties;
import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutDialog
extends JDialog
implements HyperlinkListener {
    private JEditorPane htmlPane;
    private static final Logger log = Logger.getInstance(AboutDialog.class);
    private final String UNKNOWN = Messages.getResource("unknown");

    public AboutDialog(Frame frame) {
        super(frame);
        this.setTitle(Messages.getResource("aboutTitle"));
        this.htmlPane = new JEditorPane("text/html", this.getContent());
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        int n = 300;
        int n2 = 300;
        this.setBounds(frame.getX() + (frame.getWidth() - n) / 2, frame.getY() + (frame.getHeight() - n2) / 2, n, n2);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(250, 30));
        JButton jButton = new JButton(Messages.getResource("okButton"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.setVisible(false);
            }
        });
        jButton.setSize(100, 25);
        jPanel.add((Component)jButton, "East");
        return jPanel;
    }

    private String getContent() {
        Object object;
        Object object2;
        String string = this.UNKNOWN;
        String string2 = this.UNKNOWN;
        if (JConvertProperties.getMajorVersion() != null) {
            string = JConvertProperties.getMajorVersion() + "." + JConvertProperties.getMinorVersion() + "." + JConvertProperties.getRevision();
            string2 = JConvertProperties.getBuildDate();
            object2 = new SimpleDateFormat("yyyy/MM/dd HH:mm");
            object = new SimpleDateFormat("MMM dd,yyyy hh:mm a");
            try {
                string2 = ((DateFormat)object).format(((DateFormat)object2).parse(string2));
            }
            catch (Exception exception) {
                log.error("Failed to parse the buildDate.");
            }
        }
        object2 = Locale.getDefault().getLanguage();
        if (!Locale.getDefault().getCountry().equals("")) {
            object2 = (String)object2 + "_" + Locale.getDefault().getCountry();
        }
        if (!Locale.getDefault().getVariant().equals("")) {
            object2 = (String)object2 + "_" + Locale.getDefault().getVariant();
        }
        object = Messages.getResource("projectLink");
        String string3 = Messages.getResource("downloadsLink");
        String string4 = Messages.getResource("howtoLink");
        String string5 = Messages.getResource("javaAPILink");
        Object[] objectArray = new Object[]{string, string2, Locale.getDefault().getDisplayName(), object2, object, string3, string4, string5};
        return Messages.getResource("aboutText", objectArray);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && hyperlinkEvent.getURL() != null) {
            Browser.openURL(hyperlinkEvent.getURL().toString());
        }
    }
}

