/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.common;

import com.edsdev.jconvert.common.CustomConversionDataInterface;
import com.edsdev.jconvert.common.CustomConversionImpl;
import com.edsdev.jconvert.domain.Conversion;
import com.edsdev.jconvert.domain.ConversionType;
import com.edsdev.jconvert.logic.ConversionGapBuilder;
import com.edsdev.jconvert.persistence.DataLoader;
import com.edsdev.jconvert.util.Http;
import com.edsdev.jconvert.util.Logger;
import java.io.IOException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CustomConversionCurrency
extends CustomConversionImpl
implements CustomConversionDataInterface {
    private static final String theUrl = "http://moneycentral.msn.com/investor/market/exchangerates.aspx";
    private static final String TAB_NAME = "Currency";
    private static final int SAFETY_STOP_MAX = 40;
    private static final Logger log = Logger.getInstance(CustomConversionCurrency.class);

    public CustomConversionCurrency() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1800000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CustomConversionCurrency.this.fireDataUpdatedEvent();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @Override
    public ConversionType getConversions() {
        ConversionType conversionType = this.updateData();
        conversionType.setTypeName(TAB_NAME);
        System.out.println(conversionType.getTypeName());
        ConversionGapBuilder.createOneToOneConversions(conversionType);
        ConversionGapBuilder.createMissingConversions(conversionType);
        DataLoader dataLoader = new DataLoader();
        ArrayList<ConversionType> arrayList = new ArrayList<ConversionType>();
        arrayList.add(conversionType);
        dataLoader.unloadData(arrayList, "MSNCurrency.dat");
        return conversionType;
    }

    private ConversionType updateData() {
        String string;
        String string2;
        Object object;
        StringBuffer stringBuffer = null;
        ConversionType conversionType = new ConversionType();
        try {
            object = Http.getPage(theUrl);
            stringBuffer = Http.receivePage((URLConnection)object, "UTF-8");
        }
        catch (IOException iOException) {
            log.info("Unable to connect to the internet.  Loading currency data from file.");
            DataLoader dataLoader = new DataLoader();
            List list = dataLoader.loadData("MSNCurrency.dat", false, null);
            if (list.size() == 0) {
                log.error("Could not find file to load previous currency data and cannot connect to the internet, hence cannot display currency data.");
                conversionType.setTypeName(TAB_NAME);
                return conversionType;
            }
            conversionType = (ConversionType)list.get(0);
            this.setLastUpdated(new Date());
            stringBuffer = null;
            iOException.printStackTrace();
            return conversionType;
        }
        object = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ((ArrayList)object).add("US Dollar");
        arrayList.add("1");
        String string3 = ">Per  US Dollar</th>";
        int n = stringBuffer.indexOf(string3) + string3.length();
        int n2 = 0;
        String string4 = "<tr><td>";
        String string5 = "FormatAs=Index \">";
        int n3 = n = stringBuffer.indexOf(string4, n) + string4.length();
        while (n > 0 & n2++ < 40) {
            string2 = this.getNextPlainData(stringBuffer, n).trim();
            if (!string2.equals("US Dollar")) {
                ((ArrayList)object).add(this.htmlToUnicode(string2));
                n = stringBuffer.indexOf(string5, n) + string5.length();
                n = stringBuffer.indexOf(string5, n) + string5.length();
                string = this.getNextPlainData(stringBuffer, n);
                arrayList.add(string);
                n3 = n;
                if ((n = stringBuffer.indexOf(string4, n)) <= 0) continue;
                n += string4.length();
                continue;
            }
            n = -1;
        }
        string2 = "Page generated";
        n = stringBuffer.indexOf(string2, n3) + string2.length();
        string = this.getNextPlainData(stringBuffer, n);
        try {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                conversionType.addConversion(Conversion.createInstance(((ArrayList)object).get(0).toString(), "", ((ArrayList)object).get(i).toString(), "", arrayList.get(i).toString().replaceAll(",", ""), 0.0));
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm a zzzz");
            this.setLastUpdated(simpleDateFormat.parse(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return conversionType;
    }
}

