/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.LinearCurve2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polylines2D;
import math.geom2d.transform.CircleInversion2D;

public class Polyline2D
extends LinearCurve2D
implements CirculinearContinuousCurve2D,
Cloneable {
    public static Polyline2D create(Collection<? extends Point2D> points) {
        return new Polyline2D(points);
    }

    public static Polyline2D create(Point2D ... points) {
        return new Polyline2D(points);
    }

    public Polyline2D() {
        super(1);
    }

    public Polyline2D(int nVertices) {
        super(nVertices);
    }

    public Polyline2D(Point2D initialPoint) {
        this.vertices.add(initialPoint);
    }

    public Polyline2D(Point2D ... vertices) {
        super(vertices);
    }

    public Polyline2D(Collection<? extends Point2D> vertices) {
        super(vertices);
    }

    public Polyline2D(double[] xcoords, double[] ycoords) {
        super(xcoords, ycoords);
    }

    public Polyline2D(LinearCurve2D lineString) {
        super(lineString.vertices);
        if (lineString.isClosed()) {
            this.vertices.add(lineString.firstPoint());
        }
    }

    @Override
    public Polyline2D simplify(double distMax) {
        return new Polyline2D(Polylines2D.simplifyPolyline(this.vertices, distMax));
    }

    @Override
    public Collection<LineSegment2D> edges() {
        int n = this.vertices.size();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(n);
        if (n < 2) {
            return edges;
        }
        for (int i = 0; i < n - 1; ++i) {
            edges.add(new LineSegment2D((Point2D)this.vertices.get(i), (Point2D)this.vertices.get(i + 1)));
        }
        return edges;
    }

    @Override
    public int edgeNumber() {
        int n = this.vertices.size();
        if (n > 1) {
            return n - 1;
        }
        return 0;
    }

    @Override
    public LineSegment2D edge(int index) {
        return new LineSegment2D((Point2D)this.vertices.get(index), (Point2D)this.vertices.get(index + 1));
    }

    @Override
    public LineSegment2D lastEdge() {
        int n = this.vertices.size();
        if (n < 2) {
            return null;
        }
        return new LineSegment2D((Point2D)this.vertices.get(n - 2), (Point2D)this.vertices.get(n - 1));
    }

    @Override
    public CirculinearContinuousCurve2D transform(CircleInversion2D inv) {
        Collection<LineSegment2D> edges = this.edges();
        ArrayList<CirculinearElement2D> arcs = new ArrayList<CirculinearElement2D>(edges.size());
        for (LineSegment2D edge : edges) {
            arcs.add(edge.transform(inv));
        }
        return new PolyCirculinearCurve2D(arcs);
    }

    @Override
    public double windingAngle(Point2D point) {
        double angle = 0.0;
        int n = this.vertices.size();
        for (int i = 0; i < n - 1; ++i) {
            angle += new LineSegment2D((Point2D)this.vertices.get(i), (Point2D)this.vertices.get(i + 1)).windingAngle(point);
        }
        return angle;
    }

    @Override
    public boolean isInside(Point2D pt) {
        Point2D q1;
        if (new LinearRing2D(this.vertexArray()).isInside(pt)) {
            return true;
        }
        if (this.vertices.size() < 3) {
            return false;
        }
        Point2D p0 = this.firstPoint();
        Point2D q0 = this.vertex(1);
        if (new StraightLine2D(q0, p0).isInside(pt)) {
            return false;
        }
        Point2D p1 = this.lastPoint();
        if (new StraightLine2D(p1, q1 = this.vertex(this.vertexNumber() - 2)).isInside(pt)) {
            return false;
        }
        return new StraightLine2D(p0, p1).isInside(pt);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Point2D point(double t) {
        double t0 = this.t0();
        double t1 = this.t1();
        t = Math.max(Math.min(t, t1), t0);
        int ind0 = (int)Math.floor(t + 1.0E-12);
        double tl = t - (double)ind0;
        Point2D p0 = (Point2D)this.vertices.get(ind0);
        if (Math.abs(t - (double)ind0) < 1.0E-12) {
            return p0;
        }
        int ind1 = ind0 + 1;
        Point2D p1 = (Point2D)this.vertices.get(ind1);
        double x0 = p0.x();
        double y0 = p0.y();
        double dx = p1.x() - x0;
        double dy = p1.y() - y0;
        return new Point2D(x0 + tl * dx, y0 + tl * dy);
    }

    @Override
    public double t1() {
        return this.vertices.size() - 1;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D lastPoint() {
        if (this.vertices.size() == 0) {
            return null;
        }
        return (Point2D)this.vertices.get(this.vertices.size() - 1);
    }

    @Override
    public Polyline2D reverse() {
        Point2D[] points2 = new Point2D[this.vertices.size()];
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            points2[i] = (Point2D)this.vertices.get(n - 1 - i);
        }
        return new Polyline2D(points2);
    }

    public Collection<? extends Polyline2D> continuousCurves() {
        return Polyline2D.wrapCurve(this);
    }

    @Override
    public Polyline2D subCurve(double t0, double t1) {
        int ind1;
        Polyline2D res = new Polyline2D();
        if (t1 < t0) {
            return res;
        }
        int indMax = (int)this.t1();
        t0 = Math.min(Math.max(t0, 0.0), (double)indMax);
        t1 = Math.min(Math.max(t1, 0.0), (double)indMax);
        int ind0 = (int)Math.floor(t0);
        if (ind0 == (ind1 = (int)Math.floor(t1))) {
            res.addVertex(this.point(t0));
            res.addVertex(this.point(t1));
            return res;
        }
        res.addVertex(this.point(t0));
        for (int n = ind0 + 1; n <= ind1; ++n) {
            res.addVertex((Point2D)this.vertices.get(n));
        }
        res.addVertex(this.point(t1));
        return res;
    }

    @Override
    public Polyline2D transform(AffineTransform2D trans) {
        Point2D[] pts = new Point2D[this.vertices.size()];
        for (int i = 0; i < this.vertices.size(); ++i) {
            pts[i] = trans.transform((Point2D)this.vertices.get(i));
        }
        return new Polyline2D(pts);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (this.vertices.size() < 2) {
            return path;
        }
        Iterator iter = this.vertices.iterator();
        Point2D point = (Point2D)iter.next();
        while (iter.hasNext()) {
            point = (Point2D)iter.next();
            path.lineTo((float)point.x(), (float)point.y());
        }
        return path;
    }

    @Override
    public GeneralPath asGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.vertices.size() < 2) {
            return path;
        }
        Iterator iter = this.vertices.iterator();
        Point2D point = (Point2D)iter.next();
        path.moveTo((float)point.x(), (float)point.y());
        while (iter.hasNext()) {
            point = (Point2D)iter.next();
            path.lineTo((float)point.x(), (float)point.y());
        }
        return path;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Polyline2D)) {
            return false;
        }
        Polyline2D polyline = (Polyline2D)obj;
        if (this.vertices.size() != polyline.vertices.size()) {
            return false;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (((Point2D)this.vertices.get(i)).almostEquals((GeometricObject2D)polyline.vertices.get(i), eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Polyline2D)) {
            return false;
        }
        Polyline2D polyline = (Polyline2D)object;
        if (this.vertices.size() != polyline.vertices.size()) {
            return false;
        }
        for (int i = 0; i < this.vertices.size(); ++i) {
            if (((Point2D)this.vertices.get(i)).equals(polyline.vertices.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Polyline2D clone() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(this.vertices.size());
        for (Point2D point : this.vertices) {
            array.add(point);
        }
        return new Polyline2D(array);
    }
}

