/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.ColinearPoints2DException;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CircleLine2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.conic.CircularShape2D;
import math.geom2d.conic.Conic2D;
import math.geom2d.conic.Ellipse2D;
import math.geom2d.conic.EllipseShape2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.transform.CircleInversion2D;
import math.utils.EqualUtils;

public class Circle2D
extends AbstractSmoothCurve2D
implements EllipseShape2D,
CircleLine2D,
CircularShape2D,
CirculinearRing2D,
Cloneable {
    protected double xc;
    protected double yc;
    protected double r = 0.0;
    protected boolean direct = true;
    protected double theta = 0.0;

    @Deprecated
    public static Circle2D create(Point2D center, double radius) {
        return new Circle2D(center, radius);
    }

    @Deprecated
    public static Circle2D create(Point2D center, double radius, boolean direct) {
        return new Circle2D(center, radius, direct);
    }

    @Deprecated
    public static Circle2D create(Point2D p1, Point2D p2, Point2D p3) {
        if (Point2D.isColinear(p1, p2, p3)) {
            throw new ColinearPoints2DException(p1, p2, p3);
        }
        StraightLine2D line12 = StraightLine2D.createMedian(p1, p2);
        StraightLine2D line23 = StraightLine2D.createMedian(p2, p3);
        assert (!AbstractLine2D.isParallel(line12, line23)) : "If points are not colinear, medians should not be parallel";
        Point2D center = AbstractLine2D.getIntersection(line12, line23);
        double radius = Point2D.distance(center, p2);
        return new Circle2D(center, radius);
    }

    @Deprecated
    public static Collection<Point2D> getIntersections(Circle2D circle1, Circle2D circle2) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Point2D center1 = circle1.center();
        Point2D center2 = circle2.center();
        double r1 = circle1.radius();
        double r2 = circle2.radius();
        double d = Point2D.distance(center1, center2);
        if (d < Math.abs(r1 - r2) || d > r1 + r2) {
            return intersections;
        }
        double angle = Angle2D.horizontalAngle(center1, center2);
        double d1 = d / 2.0 + (r1 * r1 - r2 * r2) / (2.0 * d);
        Point2D tmp = Point2D.createPolar(center1, d1, angle);
        double h = Math.sqrt(r1 * r1 - d1 * d1);
        intersections.add(Point2D.createPolar(tmp, h, angle + 1.5707963267948966));
        intersections.add(Point2D.createPolar(tmp, h, angle - 1.5707963267948966));
        return intersections;
    }

    @Deprecated
    public static Collection<Point2D> getIntersections(CircularShape2D circle, LinearShape2D line) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Circle2D parent = circle.supportingCircle();
        Point2D center = parent.center();
        double radius = parent.radius();
        StraightLine2D perp = StraightLine2D.createPerpendicular(line, center);
        Point2D inter = perp.intersection(new StraightLine2D(line));
        assert (inter != null);
        double dist = inter.distance(center);
        if (Math.abs(dist - radius) < 1.0E-12) {
            if (line.contains(inter) && circle.contains(inter)) {
                intersections.add(inter);
            }
            return intersections;
        }
        double angle = line.horizontalAngle();
        double d2 = Math.sqrt(radius * radius - dist * dist);
        Point2D p1 = Point2D.createPolar(inter, d2, angle + Math.PI);
        Point2D p2 = Point2D.createPolar(inter, d2, angle);
        if (line.contains(p1) && circle.contains(p1)) {
            intersections.add(p1);
        }
        if (line.contains(p2) && circle.contains(p2)) {
            intersections.add(p2);
        }
        return intersections;
    }

    public static Circle2D circumCircle(Point2D p1, Point2D p2, Point2D p3) {
        Point2D center = Circle2D.circumCenter(p1, p2, p3);
        double radius = Point2D.distance(center, p2);
        return new Circle2D(center, radius);
    }

    public static Point2D circumCenter(Point2D p1, Point2D p2, Point2D p3) {
        if (Point2D.isColinear(p1, p2, p3)) {
            throw new ColinearPoints2DException(p1, p2, p3);
        }
        StraightLine2D line12 = StraightLine2D.createMedian(p1, p2);
        StraightLine2D line23 = StraightLine2D.createMedian(p2, p3);
        assert (!AbstractLine2D.isParallel(line12, line23)) : "If points are not colinear, medians should not be parallel";
        Point2D center = AbstractLine2D.getIntersection(line12, line23);
        return center;
    }

    public static Collection<Point2D> circlesIntersections(Circle2D circle1, Circle2D circle2) {
        Point2D center1 = circle1.center();
        Point2D center2 = circle2.center();
        double r1 = circle1.radius();
        double r2 = circle2.radius();
        double d = Point2D.distance(center1, center2);
        if (d < Math.abs(r1 - r2) || d > r1 + r2) {
            return new ArrayList<Point2D>(0);
        }
        double angle = Angle2D.horizontalAngle(center1, center2);
        double d1 = d / 2.0 + (r1 * r1 - r2 * r2) / (2.0 * d);
        Point2D tmp = Point2D.createPolar(center1, d1, angle);
        double h = Math.sqrt(r1 * r1 - d1 * d1);
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Point2D p1 = Point2D.createPolar(tmp, h, angle + 1.5707963267948966);
        intersections.add(p1);
        Point2D p2 = Point2D.createPolar(tmp, h, angle - 1.5707963267948966);
        intersections.add(p2);
        return intersections;
    }

    public static Collection<Point2D> lineCircleIntersections(LinearShape2D line, CircularShape2D circle) {
        ArrayList<Point2D> intersections = new ArrayList<Point2D>(2);
        Circle2D parent = circle.supportingCircle();
        Point2D center = parent.center();
        double radius = parent.radius();
        StraightLine2D perp = StraightLine2D.createPerpendicular(line, center);
        Point2D inter = perp.intersection(new StraightLine2D(line));
        if (inter == null) {
            throw new RuntimeException("Could not compute intersection point when computing line-cicle intersection");
        }
        double dist = inter.distance(center);
        if (Math.abs(dist - radius) < 1.0E-12) {
            if (line.contains(inter) && circle.contains(inter)) {
                intersections.add(inter);
            }
            return intersections;
        }
        double angle = line.horizontalAngle();
        double d2 = Math.sqrt(radius * radius - dist * dist);
        Point2D p1 = Point2D.createPolar(inter, d2, angle + Math.PI);
        Point2D p2 = Point2D.createPolar(inter, d2, angle);
        if (line.contains(p1) && circle.contains(p1)) {
            intersections.add(p1);
        }
        if (line.contains(p2) && circle.contains(p2)) {
            intersections.add(p2);
        }
        return intersections;
    }

    public static StraightLine2D radicalAxis(Circle2D circle1, Circle2D circle2) {
        double r1 = circle1.radius();
        double r2 = circle2.radius();
        Point2D p1 = circle1.center();
        Point2D p2 = circle2.center();
        double angle = Angle2D.horizontalAngle(p1, p2);
        double dist = p1.distance(p2);
        if (dist < 1.0E-12) {
            throw new IllegalArgumentException("Input circles must have distinct centers");
        }
        double d = (dist * dist + r1 * r1 - r2 * r2) * 0.5 / dist;
        double cot = Math.cos(angle);
        double sit = Math.sin(angle);
        double x0 = p1.x() + d * cot;
        double y0 = p1.y() + d * sit;
        double dx = -sit;
        double dy = cot;
        return new StraightLine2D(x0, y0, dx, dy);
    }

    public Circle2D() {
        this(0.0, 0.0, 0.0, true);
    }

    public Circle2D(Point2D center, double radius) {
        this(center.x(), center.y(), radius, true);
    }

    public Circle2D(Point2D center, double radius, boolean direct) {
        this(center.x(), center.y(), radius, direct);
    }

    public Circle2D(double xcenter, double ycenter, double radius) {
        this(xcenter, ycenter, radius, true);
    }

    public Circle2D(double xcenter, double ycenter, double radius, boolean direct) {
        this.xc = xcenter;
        this.yc = ycenter;
        this.r = radius;
        this.direct = direct;
    }

    public double radius() {
        return this.r;
    }

    public Collection<Point2D> intersections(Circle2D circle) {
        return Circle2D.circlesIntersections(this, circle);
    }

    @Override
    public Circle2D supportingCircle() {
        return this;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    @Override
    public Point2D center() {
        return new Point2D(this.xc, this.yc);
    }

    public Vector2D vector1() {
        return new Vector2D(Math.cos(this.theta), Math.sin(this.theta));
    }

    public Vector2D vector2() {
        if (this.direct) {
            return new Vector2D(-Math.sin(this.theta), Math.cos(this.theta));
        }
        return new Vector2D(Math.sin(this.theta), -Math.cos(this.theta));
    }

    public double angle() {
        return this.theta;
    }

    public Point2D focus1() {
        return new Point2D(this.xc, this.yc);
    }

    public Point2D focus2() {
        return new Point2D(this.xc, this.yc);
    }

    @Override
    public boolean isCircle() {
        return true;
    }

    public Ellipse2D asEllipse() {
        return new Ellipse2D(this.xc, this.yc, this.r, this.r, this.theta, this.direct);
    }

    @Override
    public Conic2D.Type conicType() {
        return Conic2D.Type.CIRCLE;
    }

    @Override
    public double[] conicCoefficients() {
        return new double[]{1.0, 0.0, 1.0, -2.0 * this.xc, -2.0 * this.yc, this.xc * this.xc + this.yc * this.yc - this.r * this.r};
    }

    @Override
    public double eccentricity() {
        return 0.0;
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public Circle2D parallel(double d) {
        double rp = Math.max(this.direct ? this.r + d : this.r - d, 0.0);
        return new Circle2D(this.xc, this.yc, rp, this.direct);
    }

    @Override
    public double length() {
        return Math.PI * 2 * this.r;
    }

    @Override
    public double length(double pos) {
        return pos * this.r;
    }

    @Override
    public double position(double length) {
        return length / this.r;
    }

    @Override
    public CircleLine2D transform(CircleInversion2D inv) {
        Point2D c1;
        Point2D center = inv.center();
        if (center.distance(c1 = this.center()) < 1.0E-12) {
            double r0 = inv.radius();
            double r2 = r0 * r0 / this.r;
            return new Circle2D(center, r2, this.direct);
        }
        StraightLine2D centersLine = new StraightLine2D(center, c1);
        Collection<Point2D> points = this.intersections(centersLine);
        if (points.size() < 2) {
            throw new RuntimeException("Intersection of circle with line through center has less than 2 points");
        }
        Iterator<Point2D> iter = points.iterator();
        Point2D p1 = iter.next();
        Point2D p2 = iter.next();
        if (this.distance(center) < 1.0E-12) {
            double dist2;
            double dist1 = center.distance(p1);
            Point2D p0 = dist1 < (dist2 = center.distance(p2)) ? p2 : p1;
            p0 = p0.transform(inv);
            return StraightLine2D.createPerpendicular(centersLine, p0);
        }
        p1 = p1.transform(inv);
        p2 = p2.transform(inv);
        double diam = p1.distance(p2);
        c1 = Point2D.midPoint(p1, p2);
        boolean direct = !this.isDirect() ^ this.isInside(inv.center());
        return new Circle2D(c1, diam / 2.0, direct);
    }

    @Override
    public CirculinearDomain2D domain() {
        return new GenericCirculinearDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.xc - this.r, this.yc - this.r, 2.0 * this.r, 2.0 * this.r);
        AffineTransform trans = AffineTransform.getRotateInstance(this.theta, this.xc, this.yc);
        Shape shape = trans.createTransformedShape(ellipse);
        g2.fill(shape);
    }

    @Override
    public double windingAngle(Point2D point) {
        if (this.signedDistance(point) > 0.0) {
            return 0.0;
        }
        return this.direct ? Math.PI * 2 : Math.PI * -2;
    }

    @Override
    public Vector2D tangent(double t) {
        if (!this.direct) {
            t = -t;
        }
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double cost = Math.cos(t);
        double sint = Math.sin(t);
        if (this.direct) {
            return new Vector2D(-this.r * sint * cot - this.r * cost * sit, -this.r * sint * sit + this.r * cost * cot);
        }
        return new Vector2D(this.r * sint * cot + this.r * cost * sit, this.r * sint * sit - this.r * cost * cot);
    }

    @Override
    public double curvature(double t) {
        double k = 1.0 / this.r;
        return this.direct ? k : -k;
    }

    public Collection<? extends Circle2D> smoothPieces() {
        return Circle2D.wrapCurve(this);
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public LinearRing2D asPolyline(int n) {
        return this.asPolylineClosed(n);
    }

    @Override
    public boolean isInside(Point2D point) {
        double yp;
        double xp = (point.x() - this.xc) / this.r;
        return xp * xp + (yp = (point.y() - this.yc) / this.r) * yp < 1.0 ^ !this.direct;
    }

    @Override
    public double signedDistance(Point2D point) {
        return this.signedDistance(point.x(), point.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        if (this.direct) {
            return Point2D.distance(this.xc, this.yc, x, y) - this.r;
        }
        return this.r - Point2D.distance(this.xc, this.yc, x, y);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Math.PI * 2;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        double angle = this.theta + t;
        if (!this.direct) {
            angle = this.theta - t;
        }
        return new Point2D(this.xc + this.r * Math.cos(angle), this.yc + this.r * Math.sin(angle));
    }

    @Override
    public Point2D firstPoint() {
        return new Point2D(this.xc + this.r * Math.cos(this.theta), this.yc + this.r * Math.sin(this.theta));
    }

    @Override
    public Point2D lastPoint() {
        return new Point2D(this.xc + this.r * Math.cos(this.theta), this.yc + this.r * Math.sin(this.theta));
    }

    @Override
    public double position(Point2D point) {
        double angle = Angle2D.horizontalAngle(this.xc, this.yc, point.x(), point.y());
        if (this.direct) {
            return Angle2D.formatAngle(angle - this.theta);
        }
        return Angle2D.formatAngle(this.theta - angle);
    }

    @Override
    public double project(Point2D point) {
        double xp = point.x() - this.xc;
        double yp = point.y() - this.yc;
        return Angle2D.horizontalAngle(xp, yp);
    }

    @Override
    public Circle2D reverse() {
        return new Circle2D(this.xc, this.yc, this.r, !this.direct);
    }

    @Override
    public CircleArc2D subCurve(double t0, double t1) {
        double extent;
        double startAngle;
        if (this.direct) {
            startAngle = t0;
            extent = Angle2D.formatAngle(t1 - t0);
        } else {
            extent = -Angle2D.formatAngle(t1 - t0);
            startAngle = Angle2D.formatAngle(-t0);
        }
        return new CircleArc2D(this, startAngle, extent);
    }

    public Collection<? extends Circle2D> continuousCurves() {
        return Circle2D.wrapCurve(this);
    }

    @Override
    public double distance(Point2D point) {
        return Math.abs(Point2D.distance(this.xc, this.yc, point.x(), point.y()) - this.r);
    }

    @Override
    public double distance(double x, double y) {
        return Math.abs(Point2D.distance(this.xc, this.yc, x, y) - this.r);
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        return Circle2D.lineCircleIntersections(line, this);
    }

    @Override
    public CurveSet2D<? extends CircularShape2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<AbstractSmoothCurve2D> result = new CurveArray2D<AbstractSmoothCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (curve2D instanceof CircleArc2D) {
                result.add((CircleArc2D)curve2D);
            }
            if (!(curve2D instanceof Circle2D)) continue;
            result.add((Circle2D)curve2D);
        }
        return result;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        return Math.abs(this.distance(x, y)) <= 1.0E-12;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        if (this.direct) {
            for (double t = 0.1; t < Math.PI * 2; t += 0.1) {
                double cost = Math.cos(t);
                double sint = Math.sin(t);
                path.lineTo((float)(this.xc + this.r * cost * cot - this.r * sint * sit), (float)(this.yc + this.r * cost * sit + this.r * sint * cot));
            }
        } else {
            for (double t = 0.1; t < Math.PI * 2; t += 0.1) {
                double cost = Math.cos(t);
                double sint = Math.sin(t);
                path.lineTo((float)(this.xc + this.r * cost * cot + this.r * sint * sit), (float)(this.yc + this.r * cost * sit - this.r * sint * cot));
            }
        }
        path.lineTo((float)(this.xc + this.r * cot), (float)(this.yc + this.r * sit));
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.xc - this.r, this.yc - this.r, 2.0 * this.r, 2.0 * this.r);
        g2.draw(ellipse);
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (!(obj instanceof Circle2D)) {
            return false;
        }
        Circle2D circle = (Circle2D)obj;
        if (Math.abs(circle.xc - this.xc) > eps) {
            return false;
        }
        if (Math.abs(circle.yc - this.yc) > eps) {
            return false;
        }
        if (Math.abs(circle.r - this.r) > eps) {
            return false;
        }
        return circle.direct == this.direct;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.xc - this.r, this.xc + this.r, this.yc - this.r, this.yc + this.r);
    }

    @Override
    public EllipseShape2D transform(AffineTransform2D trans) {
        if (!AffineTransform2D.isSimilarity(trans)) {
            return this.asEllipse().transform(trans);
        }
        Point2D center = this.center().transform(trans);
        Point2D p1 = this.firstPoint().transform(trans);
        boolean direct = !this.direct ^ trans.isDirect();
        Circle2D result = new Circle2D(center, center.distance(p1), direct);
        return result;
    }

    public String toString() {
        return String.format(Locale.US, "Circle2D(%7.2f,%7.2f,%7.2f,%s)", this.xc, this.yc, this.r, this.direct ? "true" : "false");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Circle2D) {
            Circle2D that = (Circle2D)obj;
            if (!EqualUtils.areEqual(this.xc, that.xc)) {
                return false;
            }
            if (!EqualUtils.areEqual(this.yc, that.yc)) {
                return false;
            }
            if (!EqualUtils.areEqual(this.r, that.r)) {
                return false;
            }
            return this.direct == that.direct;
        }
        return super.equals(obj);
    }

    @Override
    @Deprecated
    public Circle2D clone() {
        return new Circle2D(this.xc, this.yc, this.r, this.direct);
    }
}

